/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.jce.spec;

import java.security.spec.AlgorithmParameterSpec;
import org.spongycastle.util.Arrays;

public class IESParameterSpec
implements AlgorithmParameterSpec {
    private byte[] derivation;
    private byte[] encoding;
    private int macKeySize;
    private int cipherKeySize;
    private byte[] nonce;

    public IESParameterSpec(byte[] derivation, byte[] encoding, int macKeySize) {
        this(derivation, encoding, macKeySize, -1);
    }

    public IESParameterSpec(byte[] derivation, byte[] encoding, int macKeySize, int cipherKeySize) {
        this(derivation, encoding, macKeySize, cipherKeySize, null);
    }

    public IESParameterSpec(byte[] derivation, byte[] encoding, int macKeySize, int cipherKeySize, byte[] nonce) {
        if (derivation != null) {
            this.derivation = new byte[derivation.length];
            System.arraycopy(derivation, 0, this.derivation, 0, derivation.length);
        } else {
            this.derivation = null;
        }
        if (encoding != null) {
            this.encoding = new byte[encoding.length];
            System.arraycopy(encoding, 0, this.encoding, 0, encoding.length);
        } else {
            this.encoding = null;
        }
        this.macKeySize = macKeySize;
        this.cipherKeySize = cipherKeySize;
        this.nonce = Arrays.clone((byte[])nonce);
    }

    public byte[] getDerivationV() {
        return Arrays.clone((byte[])this.derivation);
    }

    public byte[] getEncodingV() {
        return Arrays.clone((byte[])this.encoding);
    }

    public int getMacKeySize() {
        return this.macKeySize;
    }

    public int getCipherKeySize() {
        return this.cipherKeySize;
    }

    public byte[] getNonce() {
        return Arrays.clone((byte[])this.nonce);
    }
}

