/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.aptools.textblock;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseException;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.mageddo.aptools.Processor;
import com.mageddo.aptools.log.Logger;
import com.mageddo.aptools.log.LoggerFactory;
import com.mageddo.aptools.textblock.LocalVariable;
import com.mageddo.aptools.textblock.TextBlockVariableFiller;
import com.mageddo.aptools.textblock.visitor.ClassAnnotatedVariablesJavaParserScanner;
import com.mageddo.aptools.textblock.visitor.ClassAnnotatedVariablesTreePathScanner;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.TreeMaker;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import lombok.TextBlock;

public class TextBlockProcessor
implements Processor {
    private static final Class<TextBlock> TEXT_BLOCK_CLASS = TextBlock.class;
    private final Logger logger = LoggerFactory.getLogger();
    private final Trees trees;
    private final TreeMaker treeMaker;

    public TextBlockProcessor(ProcessingEnvironment processingEnv) {
        this.trees = Trees.instance(processingEnv);
        this.treeMaker = TreeMaker.instance(((JavacProcessingEnvironment)processingEnv).getContext());
    }

    public void process(Set<TypeElement> annotations, RoundEnvironment roundEnv) {
        this.logger.debug("processingover=%s, elements=%s", new Object[]{roundEnv.processingOver(), roundEnv.getRootElements()});
        for (Element element : roundEnv.getRootElements()) {
            List<VariableTree> classVars;
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)element;
            if (this.getSourceKind(classSymbol) == null || (classVars = this.getClassVars(element)).isEmpty()) continue;
            List<LocalVariable> sourceFileVars = this.getSourceFileVars((Symbol.ClassSymbol)element);
            TextBlockVariableFiller.fill(this.treeMaker, classVars, sourceFileVars);
        }
    }

    private JavaFileObject.Kind getSourceKind(Symbol.ClassSymbol classSymbol) {
        if (classSymbol.sourcefile == null) {
            return null;
        }
        return classSymbol.sourcefile.getKind();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<LocalVariable> getSourceFileVars(Symbol.ClassSymbol element) {
        try (Reader reader = element.sourcefile.openReader(true);){
            ClassAnnotatedVariablesJavaParserScanner javaParserScanner = new ClassAnnotatedVariablesJavaParserScanner(TEXT_BLOCK_CLASS);
            JavaParser.parse((Reader)reader, (boolean)true).accept((VoidVisitor)javaParserScanner, null);
            List<LocalVariable> list = javaParserScanner.getVariables();
            return list;
        }
        catch (ParseException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<VariableTree> getClassVars(Element element) {
        ClassAnnotatedVariablesTreePathScanner apScanner = new ClassAnnotatedVariablesTreePathScanner(TEXT_BLOCK_CLASS);
        apScanner.scan(this.trees.getPath(element), element);
        return apScanner.getVariables();
    }
}

