/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.aptools.textblock.visitor;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.mageddo.aptools.textblock.LocalVariable;
import com.mageddo.aptools.textblock.converter.JavaParserAnnotationConverter;
import com.mageddo.aptools.textblock.converter.JavaParserExpressionStmtConverter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import lombok.TextBlock;
import org.apache.commons.lang3.Validate;

public class ClassAnnotatedVariablesJavaParserScanner
extends VoidVisitorAdapter<CompilationUnit> {
    private final Class<? extends Annotation> annotation;
    private final List<LocalVariable> variables;

    public ClassAnnotatedVariablesJavaParserScanner(Class<? extends Annotation> annotation) {
        this.annotation = annotation;
        this.variables = new ArrayList<LocalVariable>();
    }

    public void visit(FieldDeclaration n, CompilationUnit arg) {
        for (VariableDeclarator variable : n.getVariables()) {
            LocalVariable localVariable = new LocalVariable().setName(variable.getId().getName()).setAnnotations(JavaParserAnnotationConverter.toAnnotationNames(n.getAnnotations())).setComment(this.getComment(n, variable));
            if (!localVariable.getAnnotations().contains(this.annotation.getSimpleName())) continue;
            Validate.isTrue((localVariable.getComment() != null ? 1 : 0) != 0, (String)("@" + TextBlock.class.getSimpleName() + "fields must have comments: " + variable), (Object[])new Object[0]);
            this.variables.add(localVariable);
        }
    }

    public void visit(ExpressionStmt n, CompilationUnit arg) {
        List<LocalVariable> variables = JavaParserExpressionStmtConverter.toLocalVariables((Statement)n);
        for (LocalVariable variable : variables) {
            if (!variable.getAnnotations().contains(this.annotation.getSimpleName())) continue;
            this.variables.add(variable);
        }
        super.visit(n, (Object)arg);
    }

    public List<LocalVariable> getVariables() {
        return this.variables;
    }

    private String getComment(FieldDeclaration field, VariableDeclarator variable) {
        if (variable.getComment() != null) {
            return variable.getComment().getContent();
        }
        if (field.getJavaDoc() != null) {
            return field.getJavaDoc().getContent();
        }
        if (field.getComment() != null) {
            return field.getComment().getContent();
        }
        return null;
    }
}

