/*
 * Decompiled with CFR 0.152.
 */
package nativeimage.core;

import com.mageddo.aptools.ClassUtils;
import com.mageddo.aptools.Processor;
import com.mageddo.aptools.elements.ElementFinder;
import com.mageddo.aptools.elements.ElementUtils;
import com.mageddo.aptools.log.Logger;
import com.mageddo.aptools.log.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import nativeimage.Reflection;
import nativeimage.Reflections;
import nativeimage.core.NativeImages;
import nativeimage.core.ReflectionConfigBuilder;
import nativeimage.core.ReflectionUtils;
import nativeimage.core.domain.ReflectionConfig;
import nativeimage.core.io.NativeImagePropertiesWriter;
import nativeimage.core.io.Out;
import nativeimage.core.io.ReflectionConfigWriter;
import org.apache.commons.lang3.StringUtils;

public class NativeImageReflectionConfigGenerator
implements Processor {
    private final Logger log = LoggerFactory.getLogger();
    private final ProcessingEnvironment processingEnv;
    private final Set<ReflectionConfig> classes;
    private String classPackage;

    public NativeImageReflectionConfigGenerator(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.classes = new LinkedHashSet<ReflectionConfig>();
    }

    public void process(Set<TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean processingOver = roundEnv.processingOver();
        this.processElementsForRepeatableAnnotation(roundEnv);
        this.processElementsForAnnotation(roundEnv);
        if (processingOver) {
            this.writeObjects();
        }
    }

    private void processElementsForRepeatableAnnotation(RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(Reflections.class);
        for (Element element : elements) {
            this.processElementsForRepeatableAnnotation(roundEnv, element);
        }
    }

    private void processElementsForRepeatableAnnotation(RoundEnvironment roundEnv, Element element) {
        Reflections reflections = element.getAnnotation(Reflections.class);
        for (Reflection reflection : reflections.value()) {
            this.processElementsForAnnotation(roundEnv, element, reflection);
        }
    }

    void processElementsForAnnotation(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Reflection.class)) {
            this.processElementsForAnnotation(roundEnv, element, element.getAnnotation(Reflection.class));
        }
    }

    void processElementsForAnnotation(RoundEnvironment roundEnv, Element element, Reflection reflection) {
        this.log.debug("m=processElementsForAnnotation, reflection=%s", new Object[]{reflection});
        this.addMatchingProjectSourceElements(roundEnv, element, reflection);
    }

    void addMatchingProjectSourceElements(RoundEnvironment roundEnv, Element element, Reflection reflection) {
        if (reflection.scanPackage().isEmpty()) {
            Element found = this.chooseElement(element, reflection, roundEnv);
            if (found != null) {
                this.addToElementAndNested(reflection, found);
            }
        } else {
            for (Element element2 : roundEnv.getRootElements()) {
                this.addToElementAndNested(reflection, element2);
            }
        }
    }

    private Element chooseElement(Element element, Reflection reflection, RoundEnvironment roundEnv) {
        String className = ReflectionUtils.getClassName(reflection);
        if (StringUtils.isNotBlank((CharSequence)className)) {
            return this.findElementAndNested(className, roundEnv);
        }
        return element;
    }

    private Element findElementAndNested(String className, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getRootElements()) {
            if (ElementUtils.isNotTypeElement((Element)element)) {
                this.log.debug("status=notTypeElement, element={}", new Object[]{element});
                continue;
            }
            if (ElementUtils.isEquals((Element)element, (String)className)) {
                return element;
            }
            for (Element nestedClass : ElementFinder.findNestedClasses((Element)element)) {
                if (!ElementUtils.isEquals((Element)element, (String)className)) continue;
                return nestedClass;
            }
        }
        this.log.info("status=classNotFound, class={}", new Object[]{className});
        return null;
    }

    private void addToElementAndNested(Reflection reflection, Element element) {
        this.addElement(element, reflection);
        for (Element innerClass : ElementFinder.findNestedClasses((Element)element)) {
            this.addElement(innerClass, reflection);
            this.log.debug("m=addMatchingProjectSourceElements, innerClass=%s", new Object[]{innerClass});
        }
    }

    private void addElement(Element element, Reflection annotation) {
        this.log.debug("m=addElement, asType=%s, kind=%s, simpleName=%s, enclosing=%s, clazz=%s", new Object[]{element.asType(), element.getKind(), element.getSimpleName(), element.getEnclosingElement(), element.getClass()});
        if (ElementUtils.isNotTypeElement((Element)element)) {
            return;
        }
        this.classPackage = this.classPackage == null ? ClassUtils.getClassPackage((String)element.toString()) : this.classPackage;
        for (ReflectionConfig config : ReflectionConfigBuilder.of(annotation, ElementUtils.toClassName((Element)element))) {
            this.classes.remove(config);
            this.classes.add(config);
        }
    }

    private void writeObjects() {
        String classPackage = this.getClassPackage();
        String fileName = "reflect.json";
        String reflectFile = NativeImages.solvePath(classPackage, "reflect.json");
        try (ReflectionConfigWriter appender = new ReflectionConfigWriter(Out.of(this.processingEnv, reflectFile));){
            appender.writeAll(this.classes);
            URI nativeImageFile = NativeImagePropertiesWriter.write(this.processingEnv, classPackage, "reflect.json");
            this.log.info("status=reflect-generation-done, objects=%d, path=%s", new Object[]{this.classes.size(), nativeImageFile});
            this.log.debug("objects=%s", new Object[]{this.classes});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getClassPackage() {
        return this.classPackage == null ? "graal-reflection-configuration" : this.classPackage;
    }
}

