/*
 * Decompiled with CFR 0.152.
 */
package nativeimage.core;

import java.util.LinkedHashSet;
import java.util.Set;
import nativeimage.Reflection;
import nativeimage.core.TypeBuilder;
import nativeimage.core.domain.ReflectionConfig;

public final class ReflectionConfigBuilder {
    private ReflectionConfigBuilder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static Set<ReflectionConfig> of(Reflection annotation, String clazzName) {
        LinkedHashSet<ReflectionConfig> reflectionConfigs = new LinkedHashSet<ReflectionConfig>();
        for (String type : TypeBuilder.of(annotation, clazzName)) {
            reflectionConfigs.add(ReflectionConfigBuilder.toBuilder(annotation).type(type).build());
        }
        return reflectionConfigs;
    }

    private static ReflectionConfig.ReflectionConfigBuilder toBuilder(Reflection reflectionAnn) {
        ReflectionConfig.ReflectionConfigBuilder builder = ReflectionConfig.builder().allPublicConstructors(reflectionAnn.publicConstructors()).allDeclaredConstructors(reflectionAnn.declaredConstructors()).allPublicFields(reflectionAnn.publicFields()).allDeclaredFields(reflectionAnn.declaredFields()).allPublicMethods(reflectionAnn.publicMethods()).allDeclaredMethods(reflectionAnn.declaredMethods());
        if (reflectionAnn.constructors()) {
            ReflectionConfig.withConstructors(builder);
        }
        return builder;
    }
}

