/*
 * Decompiled with CFR 0.152.
 */
package nativeimage.core;

import javax.lang.model.type.MirroredTypeException;
import nativeimage.Reflection;
import org.apache.commons.lang3.StringUtils;

public class ReflectionUtils {
    public static boolean isVoid(Reflection reflection) {
        try {
            return reflection.scanClass() == Void.class;
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror().toString().startsWith(Void.class.getName());
        }
    }

    public static String getClassName(Reflection reflectionAnn) {
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{ReflectionUtils.getScanClass(reflectionAnn), reflectionAnn.scanClassName()});
    }

    private static String getScanClass(Reflection reflectionAnn) {
        if (ReflectionUtils.isVoid(reflectionAnn)) {
            return null;
        }
        try {
            return reflectionAnn.scanClass().getName();
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror().toString();
        }
    }
}

