/*
 * Decompiled with CFR 0.152.
 */
package nativeimage.core.io;

import com.mageddo.aptools.IoUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import nativeimage.core.NativeImages;

public class NativeImagePropertiesWriter {
    public static URI write(ProcessingEnvironment processingEnv, String packageName, String ... reflectionResources) {
        URI uRI;
        Writer nativeImagePropsWriter = null;
        try {
            FileObject fileObject = processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", NativeImages.solvePath(packageName, "native-image.properties"), new Element[0]);
            nativeImagePropsWriter = fileObject.openWriter();
            nativeImagePropsWriter.append(String.format(String.format("Args=-H:ReflectionConfigurationResources=%s\n", NativeImagePropertiesWriter.buildResourcePaths(reflectionResources)), new Object[0]));
            uRI = fileObject.toUri();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtils.safeClose(nativeImagePropsWriter);
                throw throwable;
            }
        }
        IoUtils.safeClose((Closeable)nativeImagePropsWriter);
        return uRI;
    }

    private static String buildResourcePaths(String[] resources) {
        if (resources.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < resources.length - 1; ++i) {
            sb.append("${.}/");
            sb.append(resources[i]);
            sb.append('|');
        }
        sb.append("${.}/");
        sb.append(resources[resources.length - 1]);
        return sb.toString();
    }
}

