/*
 * Decompiled with CFR 0.152.
 */
package nativeimage.core.io;

import com.fasterxml.jackson.databind.SequenceWriter;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.FileObject;
import nativeimage.core.io.ReflectionConfigFileCreator;

public class Out {
    private final SequenceWriter writer;
    private final URI uri;

    public Out(SequenceWriter writer, URI uri) {
        this.writer = writer;
        this.uri = uri;
    }

    public static Out of(ProcessingEnvironment processingEnv, String fileName) {
        try {
            FileObject fileObject = ReflectionConfigFileCreator.buildFileObject(processingEnv, fileName);
            return new Out(ReflectionConfigFileCreator.createReflectionConfigWriter(fileObject.openOutputStream()), fileObject.toUri());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Out of(Path path) {
        try {
            return new Out(ReflectionConfigFileCreator.createReflectionConfigWriter(Files.newOutputStream(path, new OpenOption[0])), path.toUri());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SequenceWriter getWriter() {
        return this.writer;
    }

    public URI getUri() {
        return this.uri;
    }
}

