/*
 * Decompiled with CFR 0.152.
 */
package nativeimage.core.io;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SequenceWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class ReflectionConfigFileCreator {
    public static FileObject buildFileObject(ProcessingEnvironment processingEnv, String fileName) {
        try {
            return processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", fileName, new Element[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static SequenceWriter createReflectionConfigWriter(OutputStream out) {
        DefaultIndenter indenter = new DefaultIndenter("  ", DefaultIndenter.SYS_LF);
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
        printer.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
        printer.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
        try {
            return new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).writer((PrettyPrinter)printer).writeValuesAsArray(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

