/*
 * Decompiled with CFR 0.152.
 */
package nativeimage.core.thirdparty;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nativeimage.core.domain.ReflectionConfig;
import nativeimage.core.io.Out;
import nativeimage.core.io.ReflectionConfigWriter;
import nativeimage.core.thirdparty.ThirdPartyPackageScanner;

public class Main {
    public static final String HELP = "--help";
    public static final String CONSTRUCTORS = "--constructors";
    public static final String DECLARED_CONSTRUCTORS = "--declaredConstructors";
    public static final String PUBLIC_CONSTRUCTORS = "--publicConstructors";
    public static final String DECLARED_METHODS = "--declaredMethods";
    public static final String PUBLIC_METHODS = "--publicMethods";
    public static final String PUBLIC_FIELDS = "--publicFields";
    public static final String DECLARED_FIELDS = "--declaredFields";
    public static final Set<String> KNOWN_FLAGS = new HashSet<String>(Arrays.asList("--help", "--constructors", "--declaredConstructors", "--publicConstructors", "--declaredMethods", "--publicMethods", "--publicFields", "--declaredFields"));
    public static Map<String, Boolean> FLAGS = new HashMap<String, Boolean>();

    public static void main(String[] args) throws IOException {
        Main.processArgs(args);
        int from = args.length - 2;
        String packageName = args[from];
        Path outFilePath = Paths.get(args[from + 1], new String[0]);
        System.out.printf("generating reflect..., package=%s,  options=%s%n", packageName, Arrays.toString(args));
        try (ReflectionConfigWriter writer = new ReflectionConfigWriter(Out.of(outFilePath));){
            Set<Class<?>> classes = ThirdPartyPackageScanner.findPackageClasses(packageName);
            for (Class<?> clazz : classes) {
                writer.write(Main.toReflectionConfig(clazz));
            }
            System.out.printf("generated!, package=%s, objects=%d, writtenTo=%s%n", packageName, classes.size(), outFilePath);
        }
    }

    private static void processArgs(String[] args) {
        for (int i = 0; i < args.length - 2; ++i) {
            String arg = args[i];
            if (KNOWN_FLAGS.contains(arg)) {
                if (arg.equals(HELP)) {
                    System.out.println(KNOWN_FLAGS);
                    System.exit(0);
                }
                FLAGS.put(arg, true);
                continue;
            }
            System.err.println("unknown option: " + arg);
            System.exit(1);
        }
    }

    static ReflectionConfig toReflectionConfig(Class<?> clazz) {
        ReflectionConfig.ReflectionConfigBuilder builder = ReflectionConfig.builder().type(clazz.getName()).allDeclaredConstructors(Main.getFlag(DECLARED_CONSTRUCTORS)).allDeclaredFields(Main.getFlag(DECLARED_FIELDS)).allDeclaredMethods(Main.getFlag(DECLARED_METHODS)).allPublicFields(Main.getFlag(PUBLIC_FIELDS)).allPublicMethods(Main.getFlag(PUBLIC_METHODS));
        if (Main.getFlag(CONSTRUCTORS)) {
            ReflectionConfig.withConstructors(builder);
        }
        return builder.build();
    }

    private static boolean getFlag(String k) {
        return FLAGS.get(k) != null ? FLAGS.get(k) : false;
    }
}

