/*
 * Decompiled with CFR 0.152.
 */
package nativeimage.core.thirdparty;

import com.mageddo.aptools.ClassUtils;
import java.util.Set;
import nativeimage.Reflection;
import nativeimage.core.ReflectionUtils;
import nativeimage.core.thirdparty.ThirdPartyPackageScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThirdPartyReflectionConfigGenerator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    void addClass(Class<?> clazz, Reflection reflection) {
        this.log.debug("m=addClass, clazz=%s", clazz, clazz);
    }

    void addClassAndNested(Reflection reflection, Class<?> clazz) {
        this.addClass(clazz, reflection);
        for (Class innerClass : ClassUtils.findNestClasses(clazz)) {
            this.addClass(innerClass, reflection);
            this.log.debug("m=addMatchingProjectLibsClasses, innerClass=%s", (Object)innerClass);
        }
    }

    void addMatchingProjectLibsClasses(Reflection reflection) {
        if (reflection.scanPackage().isEmpty()) {
            this.addClassAndNested(reflection, ClassUtils.forName((String)ReflectionUtils.getClassName(reflection)));
        } else {
            Set<Class<?>> classes = ThirdPartyPackageScanner.findPackageClasses(reflection.scanPackage());
            for (Class<?> clazz : classes) {
                this.addClass(clazz, reflection);
            }
        }
    }
}

