/*
 * Decompiled with CFR 0.152.
 */
package com.magenic.jmaqs.base;

import com.magenic.jmaqs.base.BaseTestObject;
import com.magenic.jmaqs.base.ConcurrentManagerHashMap;
import com.magenic.jmaqs.base.ManagerDictionary;
import com.magenic.jmaqs.utilities.helper.StringProcessor;
import com.magenic.jmaqs.utilities.logging.ConsoleLogger;
import com.magenic.jmaqs.utilities.logging.FileLogger;
import com.magenic.jmaqs.utilities.logging.Logger;
import com.magenic.jmaqs.utilities.logging.LoggingConfig;
import com.magenic.jmaqs.utilities.logging.LoggingEnabled;
import com.magenic.jmaqs.utilities.logging.MessageType;
import com.magenic.jmaqs.utilities.logging.TestResultType;
import com.magenic.jmaqs.utilities.performance.PerfTimerCollection;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class BaseTest {
    protected ConcurrentHashMap<String, ArrayList<String>> loggedExceptions;
    protected LoggingEnabled loggingEnabledSetting;
    private ITestResult testResult;
    ConcurrentManagerHashMap baseTestObjects;
    private PerfTimerCollection perfTimerCollection;
    private ITestContext testContextInstance;
    ThreadLocal<String> fullyQualifiedTestClassName = new ThreadLocal();

    public BaseTest() {
        this.loggedExceptions = new ConcurrentHashMap();
        this.baseTestObjects = new ConcurrentManagerHashMap();
    }

    public PerfTimerCollection getPerfTimerCollection() {
        return this.perfTimerCollection;
    }

    public void setPerfTimerCollection(PerfTimerCollection perfTimerCollection) {
        this.perfTimerCollection = perfTimerCollection;
    }

    public Logger getLogger() {
        return this.getTestObject().getLogger();
    }

    public void setLogger(Logger log) {
        this.getTestObject().setLogger(log);
    }

    public LoggingEnabled getLoggingEnabledSetting() {
        return this.loggingEnabledSetting;
    }

    protected void setLoggingEnabled(LoggingEnabled setting) {
        this.loggingEnabledSetting = setting;
    }

    public List<String> getLoggedExceptions() {
        ArrayList<String> result = !this.loggedExceptions.containsKey(this.fullyQualifiedTestClassName.get()) ? new ArrayList<String>() : this.loggedExceptions.get(this.fullyQualifiedTestClassName.get());
        return result;
    }

    public void setLoggedExceptions(List<String> loggedExceptionList) {
        this.loggedExceptions.put(this.fullyQualifiedTestClassName.get(), (ArrayList)loggedExceptionList);
    }

    public ManagerDictionary getManagerStore() {
        return this.getTestObject().getManagerStore();
    }

    public ITestContext getTestContext() {
        return this.testContextInstance;
    }

    public void setTestContext(ITestContext testContext) {
        this.testContextInstance = testContext;
    }

    public BaseTestObject getTestObject() {
        if (!this.baseTestObjects.containsKey(this.fullyQualifiedTestClassName.get())) {
            this.createNewTestObject();
        }
        return (BaseTestObject)this.baseTestObjects.get(this.fullyQualifiedTestClassName.get());
    }

    public void setTestObject(BaseTestObject baseTestObject) {
        String key = this.fullyQualifiedTestClassName.get();
        if (this.baseTestObjects.containsKey(key)) {
            this.baseTestObjects.replace(key, baseTestObject);
        } else {
            this.baseTestObjects.put(key, baseTestObject);
        }
    }

    @BeforeMethod(alwaysRun=true)
    public void setup(Method method, ITestContext testContext) {
        this.testContextInstance = testContext;
        String testName = method.getDeclaringClass() + "." + method.getName();
        this.customSetup(testName, testContext);
    }

    public void customSetup(String testName, ITestContext testContext) {
        this.testContextInstance = testContext;
        testName = testName.replaceFirst("class ", "");
        this.fullyQualifiedTestClassName.set(testName);
        this.createNewTestObject();
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() {
        try {
            this.beforeLoggingTeardown(this.testResult);
        }
        catch (Exception e) {
            this.tryToLog(MessageType.WARNING, "Failed before logging teardown because: %s", e.getMessage());
        }
        if (this.testResult.getStatus() == 1) {
            this.tryToLog(MessageType.SUCCESS, "Test Passed", new Object[0]);
        } else if (this.testResult.getStatus() == 2) {
            this.tryToLog(MessageType.ERROR, "Test Failed", new Object[0]);
        } else if (this.testResult.getStatus() == 3) {
            this.tryToLog(MessageType.INFORMATION, "Test was skipped", new Object[0]);
        } else {
            this.tryToLog(MessageType.WARNING, "Test had an unexpected result.", new Object[0]);
        }
        try {
            if (this.getLogger() instanceof FileLogger && this.testResult.getStatus() == 1 && this.loggingEnabledSetting == LoggingEnabled.ONFAIL) {
                Files.delete(Paths.get(((FileLogger)this.getLogger()).getFilePath(), new String[0]));
            }
        }
        catch (Exception e) {
            this.tryToLog(MessageType.WARNING, "Failed to cleanup log files because: %s", e.getMessage());
        }
        String fullyQualifiedTestName = this.fullyQualifiedTestClassName.get();
        try (BaseTestObject baseTestObject = this.getTestObject();){
            this.loggedExceptions.remove(fullyQualifiedTestName);
            this.baseTestObjects.remove(fullyQualifiedTestName, baseTestObject);
        }
        this.setTestObject(new BaseTestObject((Logger)new ConsoleLogger(), fullyQualifiedTestName));
        this.fullyQualifiedTestClassName.remove();
    }

    @AfterMethod(alwaysRun=true)
    public void setTestResult(ITestResult testResult) {
        this.testContextInstance = testResult.getTestContext();
        this.testResult = testResult;
    }

    protected abstract void beforeLoggingTeardown(ITestResult var1);

    protected Logger createLogger() {
        this.loggingEnabledSetting = LoggingConfig.getLoggingEnabledSetting();
        this.setLoggedExceptions(new ArrayList<String>());
        Object log = this.loggingEnabledSetting != LoggingEnabled.NO ? LoggingConfig.getLogger((String)StringProcessor.safeFormatter((String)"%s - %s", (Object[])new Object[]{this.fullyQualifiedTestClassName.get(), DateTimeFormatter.ofPattern("uuuu-MM-dd-HH-mm-ss-SSSS", Locale.getDefault()).format(LocalDateTime.now(Clock.systemUTC()))})) : new ConsoleLogger();
        return log;
    }

    protected TestResultType getResultType() {
        switch (this.testResult.getStatus()) {
            case 1: {
                return TestResultType.PASS;
            }
            case 2: {
                return TestResultType.FAIL;
            }
            case 3: {
                return TestResultType.SKIP;
            }
        }
        return TestResultType.OTHER;
    }

    protected String getResultText() {
        switch (this.testResult.getStatus()) {
            case 1: {
                return "SUCCESS";
            }
            case 2: {
                return "FAILURE";
            }
            case 3: {
                return "SKIP";
            }
        }
        return "OTHER";
    }

    protected String getFullyQualifiedTestClassName() {
        return this.fullyQualifiedTestClassName.get();
    }

    protected void tryToLog(MessageType messageType, String message, Object ... args) {
        String formattedMessage = StringProcessor.safeFormatter((String)message, (Object[])args);
        try {
            this.getLogger().logMessage(messageType, formattedMessage, new Object[0]);
            if (messageType == MessageType.ERROR && !(this.getLogger() instanceof ConsoleLogger)) {
                System.out.println(formattedMessage);
            }
        }
        catch (Exception e) {
            System.out.println(formattedMessage);
            System.out.println("Logging failed because: " + e.getMessage());
        }
    }

    protected void logVerbose(String message, Object ... args) {
        StringBuilder messages = new StringBuilder();
        messages.append(StringProcessor.safeFormatter((String)message, (Object[])args) + System.lineSeparator());
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.toString().startsWith("com.magenic") || element.toString().contains("BaseTest.logVerbose")) continue;
            messages.append(element.toString() + System.lineSeparator());
        }
        this.getLogger().logMessage(MessageType.VERBOSE, messages.toString(), new Object[0]);
    }

    protected void createNewTestObject() {
        Logger newLogger = this.createLogger();
        this.setTestObject(new BaseTestObject(newLogger, this.fullyQualifiedTestClassName.get()));
    }
}

