/*
 * Decompiled with CFR 0.152.
 */
package com.magenic.jmaqs.base;

import com.magenic.jmaqs.base.DriverManager;
import com.magenic.jmaqs.base.ManagerDictionary;
import com.magenic.jmaqs.base.exceptions.DriverDisposalException;
import com.magenic.jmaqs.utilities.helper.StringProcessor;
import com.magenic.jmaqs.utilities.logging.Logger;
import com.magenic.jmaqs.utilities.logging.MessageType;
import com.magenic.jmaqs.utilities.performance.PerfTimerCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class BaseTestObject
implements AutoCloseable {
    private Logger logger;
    private PerfTimerCollection perfTimerCollection;
    private ConcurrentHashMap<String, String> values;
    private ConcurrentHashMap<String, Object> objects;
    private ManagerDictionary managerStore;
    private final ArrayList<String> associatedFiles;
    private final String fullyQualifiedTestName;
    private boolean isClosed = false;

    public boolean getClosed() {
        return this.isClosed;
    }

    public BaseTestObject(Logger logger, String fullyQualifiedTestName) {
        this.logger = logger;
        this.perfTimerCollection = new PerfTimerCollection(logger, fullyQualifiedTestName);
        this.values = new ConcurrentHashMap();
        this.objects = new ConcurrentHashMap();
        this.managerStore = new ManagerDictionary();
        this.associatedFiles = new ArrayList();
        this.fullyQualifiedTestName = fullyQualifiedTestName;
        logger.logMessage(MessageType.INFORMATION, "Setup test object for " + fullyQualifiedTestName, new Object[0]);
    }

    public BaseTestObject(BaseTestObject baseTestObject) {
        this.logger = baseTestObject.getLogger();
        this.perfTimerCollection = baseTestObject.getPerfTimerCollection();
        this.values = (ConcurrentHashMap)baseTestObject.getValues();
        this.objects = (ConcurrentHashMap)baseTestObject.getObjects();
        this.managerStore = baseTestObject.getManagerStore();
        this.associatedFiles = new ArrayList();
        this.fullyQualifiedTestName = baseTestObject.getFullyQualifiedTestName();
        baseTestObject.getLogger().logMessage(MessageType.INFORMATION, "Setup test object", new Object[0]);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public PerfTimerCollection getPerfTimerCollection() {
        return this.perfTimerCollection;
    }

    public void setPerfTimerCollection(PerfTimerCollection perfTimerCollection) {
        this.perfTimerCollection = perfTimerCollection;
    }

    public String getFullyQualifiedTestName() {
        return this.fullyQualifiedTestName;
    }

    public ConcurrentMap<String, String> getValues() {
        return this.values;
    }

    protected void setValues(ConcurrentHashMap<String, String> values) {
        this.values = values;
    }

    public ConcurrentMap<String, Object> getObjects() {
        return this.objects;
    }

    protected void setObjects(ConcurrentHashMap<String, Object> objects) {
        this.objects = objects;
    }

    public ManagerDictionary getManagerStore() {
        return this.managerStore;
    }

    protected void setManagerStore(ManagerDictionary managerStore) {
        this.managerStore = managerStore;
    }

    public void setValue(String key, String value) {
        if (this.values.containsKey(key)) {
            this.values.replace(key, value);
        } else {
            this.values.put(key, value);
        }
    }

    public void setObject(String key, Object value) {
        if (this.objects.containsKey(key)) {
            this.objects.replace(key, value);
        } else {
            this.objects.put(key, value);
        }
    }

    public <T extends DriverManager<?>> void addDriverManager(T driverManager) {
        this.addDriverManager(driverManager, false);
    }

    public <T extends DriverManager<?>> void addDriverManager(T driverManager, boolean overrideIfExists) {
        if (overrideIfExists) {
            this.overrideDriverManager(driverManager.getClass().getTypeName(), driverManager);
        } else {
            this.addDriverManager(driverManager.getClass().getTypeName(), driverManager);
        }
    }

    public void addDriverManager(String key, DriverManager<?> driverManager) {
        this.managerStore.put(key, driverManager);
    }

    public void overrideDriverManager(String key, DriverManager<?> driverManager) {
        if (this.managerStore.containsKey(key)) {
            this.managerStore.putOrOverride(key, driverManager);
        } else {
            this.managerStore.put(key, driverManager);
        }
    }

    public boolean addAssociatedFile(String path) {
        if (new File(path).exists()) {
            return this.associatedFiles.add(path);
        }
        return false;
    }

    public void close(boolean closing) {
        if (!closing) {
            this.close();
        }
    }

    @Override
    public void close() {
        if (this.managerStore == null) {
            return;
        }
        this.logger.logMessage(MessageType.VERBOSE, "Start dispose", new Object[0]);
        for (DriverManager singleDriver : this.managerStore.values()) {
            if (singleDriver != null) {
                try {
                    singleDriver.close();
                }
                catch (Exception e) {
                    throw new DriverDisposalException(StringProcessor.safeFormatter((String)"Unable to properly dispose of driver", (Object[])new Object[0]), e);
                }
            }
            this.managerStore = null;
            this.logger.logMessage(MessageType.VERBOSE, "End dispose", new Object[0]);
        }
        this.isClosed = true;
    }

    public boolean removeAssociatedFile(String path) {
        return this.associatedFiles.remove(path);
    }

    public String[] getArrayOfAssociatedFiles() {
        return this.associatedFiles.toArray(new String[0]);
    }

    public boolean containsAssociatedFile(String path) {
        return this.associatedFiles.contains(path);
    }
}

