/*
 * Decompiled with CFR 0.152.
 */
package com.magenic.jmaqs.base;

import com.magenic.jmaqs.base.BaseTestObject;
import com.magenic.jmaqs.utilities.logging.Logger;
import java.util.function.Supplier;

public abstract class DriverManager<T>
implements AutoCloseable {
    private final BaseTestObject baseTestObject;
    protected T baseDriver;
    protected Supplier<T> getDriverSupplier;

    public DriverManager(Supplier<T> getDriverFunction, BaseTestObject baseTestObject) {
        this.baseTestObject = baseTestObject;
        this.getDriverSupplier = getDriverFunction;
    }

    public T getBaseDriver() {
        return this.baseDriver;
    }

    public void setBaseDriver(T baseDriver) {
        this.baseDriver = baseDriver;
    }

    public boolean isDriverInitialized() {
        return this.baseDriver != null;
    }

    public Logger getLogger() {
        return this.baseTestObject.getLogger();
    }

    protected T getBase() {
        if (this.baseDriver == null) {
            this.baseDriver = this.getDriverSupplier.get();
        }
        return this.baseDriver;
    }

    public BaseTestObject getTestObject() {
        return this.baseTestObject;
    }
}

