/*
 * Decompiled with CFR 0.152.
 */
package com.magenic.jmaqs.base;

import com.magenic.jmaqs.base.DriverManager;
import com.magenic.jmaqs.base.exceptions.ManagerDisposalException;
import java.util.HashMap;
import java.util.Map;

public class ManagerDictionary
extends HashMap<String, DriverManager<?>>
implements AutoCloseable {
    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void clear() {
        for (Map.Entry entry : this.entrySet()) {
            try {
                ((DriverManager)entry.getValue()).close();
            }
            catch (Exception e) {
                throw new ManagerDisposalException(e);
            }
        }
        super.clear();
    }

    public <T> T getDriver(String key) {
        return (T)this.get(key);
    }

    public void put(DriverManager<?> driverManager) {
        this.put(driverManager.getClass().getName(), driverManager);
    }

    public void putOrOverride(DriverManager<?> driverManager) {
        this.putOrOverride(driverManager.getClass().getName(), driverManager);
    }

    public void putOrOverride(String key, DriverManager<?> driverManager) {
        this.remove(key);
        this.put(key, driverManager);
    }

    public boolean remove(String key) {
        if (this.containsKey(key)) {
            try {
                ((DriverManager)this.get(key)).close();
            }
            catch (Exception e) {
                throw new ManagerDisposalException(e);
            }
        }
        super.remove(key);
        return !this.containsKey(key);
    }
}

