/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.domains;

import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.MailerSendResponse;
import com.mailersend.sdk.domains.Domain;
import com.mailersend.sdk.domains.DomainAddBuilder;
import com.mailersend.sdk.domains.DomainDnsRecords;
import com.mailersend.sdk.domains.DomainDnsRecordsResponse;
import com.mailersend.sdk.domains.DomainSettingsUpdateBuilder;
import com.mailersend.sdk.domains.DomainVerificationStatus;
import com.mailersend.sdk.domains.DomainsList;
import com.mailersend.sdk.domains.SingleDomainResponse;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.util.ApiRecipientsList;
import java.util.ArrayList;
import java.util.Arrays;

public class Domains {
    private MailerSend apiObjectReference;
    private int pageFilter = 1;
    private int limitFilter = 25;
    private int verifiedOnly = -1;
    private DomainAddBuilder addDomainBuilder;
    private DomainSettingsUpdateBuilder updateDomainSettingsBuilder;

    public Domains(MailerSend ref) {
        this.apiObjectReference = ref;
        this.addDomainBuilder = new DomainAddBuilder(ref);
        this.updateDomainSettingsBuilder = new DomainSettingsUpdateBuilder(ref);
    }

    public DomainAddBuilder addDomainBuilder() {
        return this.addDomainBuilder;
    }

    public DomainSettingsUpdateBuilder updateDomainSettingsBuilder() {
        return this.updateDomainSettingsBuilder;
    }

    public Domains page(int page) {
        this.pageFilter = page;
        return this;
    }

    public Domains limit(int limit) {
        this.limitFilter = limit;
        return this;
    }

    public Domains onlyVerified() {
        this.verifiedOnly = 1;
        return this;
    }

    public Domains onlyUnverified() {
        this.verifiedOnly = 0;
        return this;
    }

    public Domains all() {
        this.verifiedOnly = -1;
        return this;
    }

    public DomainsList getDomains() throws MailerSendException {
        String endpoint = "/domains".concat(this.prepareParamsUrl());
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        DomainsList response = api.getRequest(endpoint, DomainsList.class);
        return response;
    }

    public Domain getDomain(String domainId) throws MailerSendException {
        String endpoint = "/domains/".concat(domainId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        SingleDomainResponse response = api.getRequest(endpoint, SingleDomainResponse.class);
        return response.domain;
    }

    public boolean deleteDomain(String domainId) throws MailerSendException {
        String endpoint = "/domains/".concat(domainId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        MailerSendResponse response = api.deleteRequest(endpoint, MailerSendResponse.class);
        return Arrays.asList(new int[][]{{200, 204, 202}}).contains(response.responseStatusCode);
    }

    public ApiRecipientsList getDomainRecipients(String domainId) throws MailerSendException {
        String endpoint = "/domains/".concat(domainId).concat("/recipients").concat(this.prepareParamsUrl());
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        ApiRecipientsList response = api.getRequest(endpoint, ApiRecipientsList.class);
        response.postProcessing();
        return response;
    }

    public DomainDnsRecords getDomainDnsRecords(String domainId) throws MailerSendException {
        String endpoint = "/domains/".concat(domainId).concat("/dns-records");
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        DomainDnsRecordsResponse response = api.getRequest(endpoint, DomainDnsRecordsResponse.class);
        return response.records;
    }

    public DomainVerificationStatus verifyDomain(String domainId) throws MailerSendException {
        String endpoint = "/domains/".concat(domainId).concat("/verify");
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        DomainVerificationStatus response = api.getRequest(endpoint, DomainVerificationStatus.class);
        return response;
    }

    private String prepareParamsUrl() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("page=".concat(String.valueOf(this.pageFilter)));
        params.add("limit=".concat(String.valueOf(this.limitFilter)));
        if (this.verifiedOnly == 0) {
            params.add("verified=false");
        } else if (this.verifiedOnly == 1) {
            params.add("verified=true");
        }
        String requestParams = "";
        for (int i = 0; i < params.size(); ++i) {
            String attrSep = "&";
            if (i == 0) {
                attrSep = "?";
            }
            requestParams = requestParams.concat(attrSep).concat((String)params.get(i));
        }
        return requestParams;
    }
}

