/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.activities;

import com.google.gson.annotations.SerializedName;
import com.mailersend.sdk.Recipient;
import com.mailersend.sdk.emails.Email;
import com.mailersend.sdk.util.ApiRecipient;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.Date;

public class ActivityEmail {
    @SerializedName(value="id")
    public String id;
    @SerializedName(value="from")
    public String from;
    @SerializedName(value="subject")
    public String subject;
    @SerializedName(value="text")
    public String text;
    @SerializedName(value="html")
    public String html;
    @SerializedName(value="status")
    public String status;
    @SerializedName(value="tags")
    public String[] tags;
    public Date createdAt;
    public Date updatedAt;
    @SerializedName(value="recipient")
    public ApiRecipient recipient;
    @SerializedName(value="created_at")
    private String createdAtString;
    @SerializedName(value="updated_at")
    private String updatedAtString;

    protected void postDeserialize() {
        this.parseDates();
        if (this.recipient != null) {
            this.recipient.parseDates();
        }
    }

    private void parseDates() {
        Instant instant;
        TemporalAccessor ta;
        if (this.createdAtString != null && !this.createdAtString.isBlank()) {
            ta = DateTimeFormatter.ISO_INSTANT.parse(this.createdAtString);
            instant = Instant.from(ta);
            this.createdAt = Date.from(instant);
        }
        if (this.updatedAtString != null && !this.updatedAtString.isBlank()) {
            ta = DateTimeFormatter.ISO_INSTANT.parse(this.updatedAtString);
            instant = Instant.from(ta);
            this.updatedAt = Date.from(instant);
        }
    }

    public Email toEmail() {
        Email email = new Email();
        email.subject = this.subject;
        email.from = new Recipient("", this.from);
        email.html = this.html;
        email.text = this.text;
        Collections.addAll(email.tags, this.tags);
        email.AddRecipient(this.recipient.toRecipient());
        return email;
    }
}

