/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.domains;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.domains.Domain;
import com.mailersend.sdk.domains.DomainAddRequestBody;
import com.mailersend.sdk.domains.SingleDomainResponse;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.util.JsonSerializationDeserializationStrategy;

public class DomainAddBuilder {
    private MailerSend apiObjectReference;
    private DomainAddRequestBody domainAddBody;

    protected DomainAddBuilder(MailerSend apiObjectRef) {
        this.apiObjectReference = apiObjectRef;
        this.domainAddBody = new DomainAddRequestBody();
    }

    public DomainAddBuilder returnPathSubdomain(String returnPathSubdomain) {
        this.domainAddBody.returnPathSubdomainValue = returnPathSubdomain;
        return this;
    }

    public DomainAddBuilder customTrackingSubdomain(String customTrackingSubdomain) {
        this.domainAddBody.customTrackingSubdomainValue = customTrackingSubdomain;
        return this;
    }

    public DomainAddBuilder inboundRoutingSubdomain(String inboundRoutingSubdomain) {
        this.domainAddBody.inboundRoutingSubdomainValue = inboundRoutingSubdomain;
        return this;
    }

    public Domain addDomain(String name) throws MailerSendException {
        String endpoint = "/domains";
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        this.domainAddBody.name = name;
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(false)).addDeserializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(true)).create();
        String json = gson.toJson((Object)this.domainAddBody);
        this.domainAddBody.reset();
        SingleDomainResponse response = api.postRequest(endpoint, json, SingleDomainResponse.class);
        return response.domain;
    }
}

