/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.inboundroutes;

import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.MailerSendResponse;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.inboundroutes.InboundRoute;
import com.mailersend.sdk.inboundroutes.InboundRouteBuilder;
import com.mailersend.sdk.inboundroutes.InboundRoutesList;
import com.mailersend.sdk.inboundroutes.SingleInboundRouteResponse;
import java.util.ArrayList;
import java.util.stream.IntStream;

public class InboundRoutes {
    private MailerSend apiObjectReference;
    private int pageFilter = 1;
    private int limitFilter = 25;
    private String domainIdFilter;
    private InboundRouteBuilder inboundRouteBuilder;

    public InboundRoutes(MailerSend ref) {
        this.apiObjectReference = ref;
        this.inboundRouteBuilder = new InboundRouteBuilder(ref);
    }

    public InboundRouteBuilder getNewBuilder() {
        return new InboundRouteBuilder(this.apiObjectReference);
    }

    public InboundRouteBuilder builder() {
        return this.inboundRouteBuilder;
    }

    public InboundRoutes page(int page) {
        this.pageFilter = page;
        return this;
    }

    public InboundRoutes limit(int limit) {
        this.limitFilter = limit;
        return this;
    }

    public InboundRoutes domainId(String domainId) {
        this.domainIdFilter = domainId;
        return this;
    }

    public InboundRoutesList getRoutes() throws MailerSendException {
        String endpoint = "/inbound".concat(this.prepareParamsUrl());
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        InboundRoutesList response = api.getRequest(endpoint, InboundRoutesList.class);
        return response;
    }

    public InboundRoute getRoute(String routeId) throws MailerSendException {
        String endpoint = "/inbound/".concat(routeId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        SingleInboundRouteResponse response = api.getRequest(endpoint, SingleInboundRouteResponse.class);
        return response.route;
    }

    public boolean deleteRoute(String routeId) throws MailerSendException {
        String endpoint = "/inbound/".concat(routeId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        MailerSendResponse response = api.deleteRequest(endpoint, MailerSendResponse.class);
        return IntStream.of(200, 204, 202).anyMatch(x -> x == response.responseStatusCode);
    }

    private String prepareParamsUrl() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("page=".concat(String.valueOf(this.pageFilter)));
        params.add("limit=".concat(String.valueOf(this.limitFilter)));
        if (this.domainIdFilter != null) {
            params.add("domain_id=".concat(this.domainIdFilter));
        }
        String requestParams = "";
        for (int i = 0; i < params.size(); ++i) {
            String attrSep = "&";
            if (i == 0) {
                attrSep = "?";
            }
            requestParams = requestParams.concat(attrSep).concat((String)params.get(i));
        }
        return requestParams;
    }
}

