/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.sms;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.MailerSendResponse;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.sms.SmsBuilderBody;
import com.mailersend.sdk.sms.SmsPersonalization;
import com.mailersend.sdk.util.JsonSerializationDeserializationStrategy;
import java.util.List;
import java.util.Map;

public class SmsBuilder {
    private SmsBuilderBody builderBody;
    private MailerSend apiObjectReference;

    public SmsBuilder(MailerSend ref) {
        this.apiObjectReference = ref;
        this.builderBody = new SmsBuilderBody();
    }

    public SmsBuilder addPersonalization(String phoneNumber, String name, Object value) {
        SmsPersonalization entry = null;
        for (SmsPersonalization p : this.builderBody.personalization) {
            if (!p.phoneNumber.equals(phoneNumber)) continue;
            entry = p;
            break;
        }
        if (entry != null) {
            entry.data.put(name, value);
        } else {
            entry = new SmsPersonalization();
            entry.phoneNumber = phoneNumber;
            entry.data.put(name, value);
            this.builderBody.personalization.add(entry);
        }
        return this;
    }

    public SmsBuilder from(String from) {
        this.builderBody.from = from;
        return this;
    }

    public SmsBuilder text(String text) {
        this.builderBody.text = text;
        return this;
    }

    public SmsBuilder addRecipient(String phoneNumber) {
        this.builderBody.to.add(phoneNumber);
        return this;
    }

    public String send() throws MailerSendException {
        String endpoint = "/sms";
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(false)).addDeserializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(true)).create();
        String json = gson.toJson((Object)this.builderBody);
        this.builderBody = new SmsBuilderBody();
        MailerSendResponse response = api.postRequest(endpoint, json, MailerSendResponse.class);
        String messageId = null;
        for (Map.Entry<String, List<String>> entry : response.headers.entrySet()) {
            if (!entry.getKey().equals("x-sms-message-id")) continue;
            messageId = entry.getValue().get(0);
            break;
        }
        return messageId;
    }
}

