/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sms.webhooks;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.util.JsonSerializationDeserializationStrategy;
import com.mailersend.sms.webhooks.SingleSmsWebhookResponse;
import com.mailersend.sms.webhooks.SmsWebhook;
import com.mailersend.sms.webhooks.SmsWebhookBuilderBody;

public class SmsWebhooksBuilder {
    private SmsWebhookBuilderBody builderBody = new SmsWebhookBuilderBody();
    private MailerSend apiObjectReference;

    protected SmsWebhooksBuilder(MailerSend apiObjectRef) {
        this.apiObjectReference = apiObjectRef;
    }

    public SmsWebhooksBuilder url(String url) {
        this.builderBody.url = url;
        return this;
    }

    public SmsWebhooksBuilder name(String name) {
        this.builderBody.name = name;
        return this;
    }

    public SmsWebhooksBuilder addEvent(String event) {
        this.builderBody.events.add(event);
        return this;
    }

    public SmsWebhooksBuilder clearEvents() {
        this.builderBody.events.clear();
        return this;
    }

    public SmsWebhook createWebhook(String smsNumberId) throws MailerSendException {
        this.builderBody.smsNumberId = smsNumberId;
        if (this.builderBody.name == null || this.builderBody.name.isBlank()) {
            throw new MailerSendException("Webhook name cannot be empty");
        }
        if (this.builderBody.url == null || this.builderBody.url.isBlank()) {
            throw new MailerSendException("Webhook URL cannot be empty");
        }
        if (smsNumberId == null || smsNumberId.isBlank()) {
            throw new MailerSendException("Sms number ID cannot be empty");
        }
        String endpoint = "/sms-webhooks";
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(false)).addDeserializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(true)).create();
        String json = gson.toJson((Object)this.builderBody);
        this.builderBody = new SmsWebhookBuilderBody();
        SingleSmsWebhookResponse response = api.postRequest(endpoint, json, SingleSmsWebhookResponse.class);
        return response.webhook;
    }

    public SmsWebhook updateWebhook(String webhookId) throws MailerSendException {
        if (webhookId == null || webhookId.isBlank()) {
            throw new MailerSendException("Webhook ID cannot be empty");
        }
        String endpoint = "/sms-webhooks/".concat(webhookId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(false)).addDeserializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(true)).create();
        String json = gson.toJson((Object)this.builderBody);
        this.builderBody = new SmsWebhookBuilderBody();
        SingleSmsWebhookResponse response = api.putRequest(endpoint, json, SingleSmsWebhookResponse.class);
        return response.webhook;
    }
}

