/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.domains;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.domains.Domain;
import com.mailersend.sdk.domains.DomainSettings;
import com.mailersend.sdk.domains.SingleDomainResponse;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.util.JsonSerializationDeserializationStrategy;

public class DomainSettingsUpdateBuilder {
    private MailerSend apiObjectReference;
    private DomainSettings settings;

    protected DomainSettingsUpdateBuilder(MailerSend apiObjectRef) {
        this.apiObjectReference = apiObjectRef;
        this.settings = new DomainSettings();
    }

    public DomainSettingsUpdateBuilder sendPaused(boolean sendPaused) {
        this.settings.sendPaused = sendPaused;
        return this;
    }

    public DomainSettingsUpdateBuilder trackClicks(boolean trackClicks) {
        this.settings.trackClicks = trackClicks;
        return this;
    }

    public DomainSettingsUpdateBuilder trackOpens(boolean trackOpens) {
        this.settings.trackOpens = trackOpens;
        return this;
    }

    public DomainSettingsUpdateBuilder trackUnsubscribe(boolean trackUnsubscribe) {
        this.settings.trackUnsubscribe = trackUnsubscribe;
        return this;
    }

    public DomainSettingsUpdateBuilder trackUnsubscribeHtml(String html) {
        this.settings.trackUnsubscribeHtml = html;
        return this;
    }

    public DomainSettingsUpdateBuilder trackUnsubscribePlain(String plain) {
        this.settings.trackUnsubscribePlain = plain;
        return this;
    }

    public DomainSettingsUpdateBuilder trackContent(boolean trackContent) {
        this.settings.trackContent = trackContent;
        return this;
    }

    public DomainSettingsUpdateBuilder customnTrackingEnabled(boolean customTrackingEnabled) {
        this.settings.customTrackingEnabled = customTrackingEnabled;
        return this;
    }

    public DomainSettingsUpdateBuilder customTrackingSubdomain(String customTrackingSubdomain) {
        this.settings.customTrackingSubdomain = customTrackingSubdomain;
        return this;
    }

    public Domain updateDomain(String domainId) throws MailerSendException {
        String endpoint = "/domains/".concat(domainId).concat("/settings");
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(false)).addDeserializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(true)).create();
        String json = gson.toJson((Object)this.settings);
        this.settings.reset();
        SingleDomainResponse response = api.putRequest(endpoint, json, SingleDomainResponse.class);
        return response.domain;
    }
}

