/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.templates;

import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.MailerSendResponse;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.templates.Template;
import com.mailersend.sdk.templates.TemplateResponse;
import com.mailersend.sdk.templates.TemplatesList;
import java.util.ArrayList;

public class Templates {
    private MailerSend apiObjectReference;
    private int pageFilter = 1;
    private int limitFilter = 25;
    private String domainIdFilter = null;

    public Templates(MailerSend ref) {
        this.apiObjectReference = ref;
    }

    public Templates page(int page) {
        this.pageFilter = page;
        return this;
    }

    public Templates limit(int limit) {
        this.limitFilter = limit;
        return this;
    }

    public Templates domainId(String domainId) {
        this.domainIdFilter = domainId;
        return this;
    }

    public TemplatesList getTemplates() throws MailerSendException {
        String endpoint = "/templates".concat(this.prepareParamsUrl());
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        TemplatesList response = api.getRequest(endpoint, TemplatesList.class);
        response.postDeserialize();
        return response;
    }

    public Template getTemplate(String templateId) throws MailerSendException {
        String endpoint = "/templates/".concat(templateId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        TemplateResponse response = api.getRequest(endpoint, TemplateResponse.class);
        if (response.template != null) {
            response.template.postDeserialize();
        }
        return response.template;
    }

    public MailerSendResponse deleteTemplate(String templateId) throws MailerSendException {
        String endpoint = "/templates/".concat(templateId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        MailerSendResponse response = api.deleteRequest(endpoint, MailerSendResponse.class);
        return response;
    }

    private String prepareParamsUrl() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("page=".concat(String.valueOf(this.pageFilter)));
        params.add("limit=".concat(String.valueOf(this.limitFilter)));
        if (this.domainIdFilter != null) {
            params.add("domain_id=".concat(this.domainIdFilter));
        }
        String requestParams = "";
        for (int i = 0; i < params.size(); ++i) {
            String attrSep = "&";
            if (i == 0) {
                attrSep = "?";
            }
            requestParams = requestParams.concat(attrSep).concat((String)params.get(i));
        }
        return requestParams;
    }
}

