/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.templates;

import com.google.gson.annotations.SerializedName;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public class TemplateStats {
    @SerializedName(value="total")
    public int total;
    @SerializedName(value="processed")
    public int processed;
    @SerializedName(value="queued")
    public int queued;
    @SerializedName(value="sent")
    public int sent;
    @SerializedName(value="rejected")
    public int rejected;
    @SerializedName(value="delivered")
    public int delivered;
    public Date lastEmailSentAt;
    @SerializedName(value="last_email_sent_at")
    private String lastEmailSentAtStr;

    protected void postDeserialize() {
        this.parseDates();
    }

    protected void parseDates() {
        if (this.lastEmailSentAtStr != null && !this.lastEmailSentAtStr.isBlank()) {
            TemporalAccessor ta = DateTimeFormatter.ISO_INSTANT.parse(this.lastEmailSentAtStr);
            Instant instant = Instant.from(ta);
            this.lastEmailSentAt = Date.from(instant);
        }
    }
}

