/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.webhooks;

import com.google.gson.annotations.SerializedName;
import com.mailersend.sdk.domains.Domain;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public class Webhook {
    @SerializedName(value="id")
    public String id;
    @SerializedName(value="url")
    public String url;
    @SerializedName(value="events")
    public String[] events;
    @SerializedName(value="name")
    public String name;
    @SerializedName(value="enabled")
    public Boolean enabled;
    @SerializedName(value="editable")
    public Boolean editable;
    public Date createdAt;
    @SerializedName(value="created_at")
    private String createdAtStr;
    public Date updatedAt;
    @SerializedName(value="updated_at")
    private String updatedAtStr;
    @SerializedName(value="domain")
    public Domain domain;

    protected void postDeserialize() {
        this.parseDates();
    }

    protected void parseDates() {
        Instant instant;
        TemporalAccessor ta;
        if (this.createdAtStr != null && !this.createdAtStr.isBlank()) {
            ta = DateTimeFormatter.ISO_INSTANT.parse(this.createdAtStr);
            instant = Instant.from(ta);
            this.createdAt = Date.from(instant);
        }
        if (this.updatedAtStr != null && !this.updatedAtStr.isBlank()) {
            ta = DateTimeFormatter.ISO_INSTANT.parse(this.updatedAtStr);
            instant = Instant.from(ta);
            this.updatedAt = Date.from(instant);
        }
        if (this.domain != null) {
            this.domain.postDeserialize();
        }
    }
}

