/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.api.v3;

import com.mailgun.api.MailgunApi;
import com.mailgun.enums.YesNo;
import com.mailgun.enums.YesNoHtml;
import com.mailgun.expanders.EnumExpander;
import com.mailgun.model.ResponseWithMessage;
import com.mailgun.model.domains.DomainConnectionRequest;
import com.mailgun.model.domains.DomainConnectionResponse;
import com.mailgun.model.domains.DomainCredentials;
import com.mailgun.model.domains.DomainListResponse;
import com.mailgun.model.domains.DomainRequest;
import com.mailgun.model.domains.DomainResponse;
import com.mailgun.model.domains.DomainTrackingResponse;
import com.mailgun.model.domains.DomainUnsubscribeConnectionSettingsRequest;
import com.mailgun.model.domains.DomainsParametersFilter;
import com.mailgun.model.domains.SingleDomainResponse;
import com.mailgun.model.domains.UpdateDomainClickTrackingSettingsResponse;
import com.mailgun.model.domains.UpdateDomainConnectionResponse;
import com.mailgun.model.domains.UpdateDomainOpenTrackingSettingsResponse;
import com.mailgun.model.domains.UpdateDomainUnsubscribeTrackingSettingsResponse;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import feign.Response;

@Headers(value={"Accept: application/json"})
public interface MailgunDomainsApi
extends MailgunApi {
    @RequestLine(value="GET /domains")
    public DomainListResponse getDomainsList();

    @RequestLine(value="GET /domains")
    public Response getDomainsListFeignResponse();

    @RequestLine(value="GET /domains")
    public DomainListResponse getDomainsList(@QueryMap DomainsParametersFilter var1);

    @RequestLine(value="GET /domains")
    public Response getDomainsListFeignResponse(@QueryMap DomainsParametersFilter var1);

    @RequestLine(value="GET /domains/{domain}")
    public SingleDomainResponse getSingleDomain(@Param(value="domain") String var1);

    @RequestLine(value="GET /domains/{domain}")
    public Response getSingleDomainFeignResponse(@Param(value="domain") String var1);

    @RequestLine(value="PUT /domains/{domain}/verify")
    public DomainResponse verifyDomain(@Param(value="domain") String var1);

    @RequestLine(value="PUT /domains/{domain}/verify")
    public Response verifyDomainFeignResponse(@Param(value="domain") String var1);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="POST /domains")
    public DomainResponse createNewDomain(DomainRequest var1);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="POST /domains")
    public Response createNewDomainFeignResponse(DomainRequest var1);

    @RequestLine(value="DELETE /domains/{domain}")
    public ResponseWithMessage deleteDomain(@Param(value="domain") String var1);

    @RequestLine(value="DELETE /domains/{domain}")
    public Response deleteDomainFeignResponse(@Param(value="domain") String var1);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="POST /domains/{domain}/credentials")
    public ResponseWithMessage createNewCredentials(@Param(value="domain") String var1, DomainCredentials var2);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="POST /domains/{domain}/credentials")
    public Response createNewCredentialsFeignResponse(@Param(value="domain") String var1, DomainCredentials var2);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="PUT /domains/{domain}/credentials/{login}")
    public ResponseWithMessage updateCredentials(@Param(value="domain") String var1, @Param(value="login") String var2, @Param(value="password") String var3);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="PUT /domains/{domain}/credentials/{login}")
    public Response updateCredentialsFeignResponse(@Param(value="domain") String var1, @Param(value="login") String var2, @Param(value="password") String var3);

    @RequestLine(value="DELETE /domains/{domain}/credentials/{login}")
    public ResponseWithMessage deleteCredentials(@Param(value="domain") String var1, @Param(value="login") String var2);

    @RequestLine(value="DELETE /domains/{domain}/credentials/{login}")
    public Response deleteCredentialsFeignResponse(@Param(value="domain") String var1, @Param(value="login") String var2);

    @RequestLine(value="GET /domains/{domain}/connection")
    public DomainConnectionResponse getDomainConnectionSettings(@Param(value="domain") String var1);

    @RequestLine(value="GET /domains/{domain}/connection")
    public Response getDomainConnectionSettingsFeignResponse(@Param(value="domain") String var1);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="PUT /domains/{domain}/connection")
    public UpdateDomainConnectionResponse updateDomainConnectionSettings(@Param(value="domain") String var1, DomainConnectionRequest var2);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="PUT /domains/{domain}/connection")
    public Response updateDomainConnectionSettingsFeignResponse(@Param(value="domain") String var1, DomainConnectionRequest var2);

    @RequestLine(value="GET /domains/{domain}/tracking")
    public DomainTrackingResponse getDomainTrackingSettings(@Param(value="domain") String var1);

    @RequestLine(value="GET /domains/{domain}/tracking")
    public Response getDomainTrackingSettingsFeignResponse(@Param(value="domain") String var1);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="PUT /domains/{domain}/tracking/open")
    public UpdateDomainOpenTrackingSettingsResponse updateDomainOpenTrackingSettings(@Param(value="domain") String var1, @Param(value="active", expander=EnumExpander.class) YesNo var2);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="PUT /domains/{domain}/tracking/open")
    public Response updateDomainOpenTrackingSettingsFeignResponse(@Param(value="domain") String var1, @Param(value="active", expander=EnumExpander.class) YesNo var2);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="PUT /domains/{domain}/tracking/click")
    public UpdateDomainClickTrackingSettingsResponse updateDomainClickTrackingSettings(@Param(value="domain") String var1, @Param(value="active", expander=EnumExpander.class) YesNoHtml var2);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="PUT /domains/{domain}/tracking/click")
    public Response updateDomainClickTrackingSettingsFeignResponse(@Param(value="domain") String var1, @Param(value="active", expander=EnumExpander.class) YesNoHtml var2);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="PUT /domains/{domain}/tracking/unsubscribe")
    public UpdateDomainUnsubscribeTrackingSettingsResponse updateDomainUnsubscribeConnectionSettings(@Param(value="domain") String var1, DomainUnsubscribeConnectionSettingsRequest var2);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="PUT /domains/{domain}/tracking/unsubscribe")
    public Response updateDomainUnsubscribeConnectionSettingsFeignResponse(@Param(value="domain") String var1, DomainUnsubscribeConnectionSettingsRequest var2);
}

