/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mailgun.api.MailgunApi;
import com.mailgun.util.ConsoleLogger;
import com.mailgun.util.MailgunApiUtil;
import com.mailgun.util.ObjectMapperUtil;
import feign.AsyncClient;
import feign.AsyncFeign;
import feign.Feign;
import feign.Logger;
import feign.QueryMapEncoder;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.form.FormEncoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.querymap.FieldQueryMapEncoder;

public final class MailgunClient {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperUtil.getObjectMapper();
    private static final FormEncoder ENCODER = new FormEncoder((Encoder)new JacksonEncoder(OBJECT_MAPPER));
    private static final JacksonDecoder DECODER = new JacksonDecoder(OBJECT_MAPPER);
    private static final FieldQueryMapEncoder QUERY_MAP_ENCODER = new FieldQueryMapEncoder();

    public static MailgunClientBuilder config(String baseUrl, String apiKey) {
        return new MailgunClientBuilder(baseUrl, apiKey);
    }

    public static MailgunClientBuilder config(String apiKey) {
        return new MailgunClientBuilder(apiKey);
    }

    private MailgunClient() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class MailgunClientBuilder {
        private Logger.Level logLevel = Logger.Level.BASIC;
        private Retryer retryer = new Retryer.Default();
        private Logger logger = new ConsoleLogger();
        private ErrorDecoder errorDecoder = new ErrorDecoder.Default();
        private Request.Options options = new Request.Options();
        private AsyncClient<Object> client = null;
        private String baseUrl = "https://api.mailgun.net/";
        private final String apiKey;

        private MailgunClientBuilder(String baseUrl, String apiKey) {
            this.baseUrl = baseUrl;
            this.apiKey = apiKey;
        }

        private MailgunClientBuilder(String apiKey) {
            this.apiKey = apiKey;
        }

        public MailgunClientBuilder client(AsyncClient<Object> client) {
            this.client = client;
            return this;
        }

        public MailgunClientBuilder logLevel(Logger.Level logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public MailgunClientBuilder retryer(Retryer retryer) {
            this.retryer = retryer;
            return this;
        }

        public MailgunClientBuilder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public MailgunClientBuilder errorDecoder(ErrorDecoder errorDecoder) {
            this.errorDecoder = errorDecoder;
            return this;
        }

        public MailgunClientBuilder options(Request.Options options) {
            this.options = options;
            return this;
        }

        public <T> T createApi(Class<? extends MailgunApi> apiType) {
            String url = MailgunApiUtil.getFullUrl(apiType, this.baseUrl);
            return (T)this.getFeignBuilder().target(apiType, url);
        }

        public <T> T createAsyncApi(Class<? extends MailgunApi> apiType) {
            String url = MailgunApiUtil.getFullUrl(apiType, this.baseUrl);
            return (T)this.getAsyncFeignBuilder().target(apiType, url);
        }

        public <T> T createApiWithAbsoluteUrl(Class<? extends MailgunApi> apiType) {
            return (T)this.getFeignBuilder().target(apiType, this.baseUrl);
        }

        private Feign.Builder getFeignBuilder() {
            return Feign.builder().logLevel(this.logLevel).retryer(this.retryer).logger(this.logger).encoder((Encoder)ENCODER).decoder((Decoder)DECODER).queryMapEncoder((QueryMapEncoder)QUERY_MAP_ENCODER).errorDecoder(this.errorDecoder).options(this.options).requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor("api", this.apiKey));
        }

        private AsyncFeign.AsyncBuilder<?> getAsyncFeignBuilder() {
            return AsyncFeign.asyncBuilder().logLevel(this.logLevel).logger(this.logger).encoder((Encoder)ENCODER).decoder((Decoder)DECODER).queryMapEncoder((QueryMapEncoder)QUERY_MAP_ENCODER).errorDecoder(this.errorDecoder).options(this.options).client(this.client).requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor("api", this.apiKey));
        }
    }
}

