/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.util;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateTimeUtil {
    private static final Logger log = LoggerFactory.getLogger(DateTimeUtil.class);
    private static final String UNABLE_TO_FORMAT_PROVIDED_ZONED_DATE_TIME = "Unable to format provided ZonedDateTime";
    private static final DateTimeFormatter FORMATTER_DATE_TIME_PATTERN_TIME_ZONE = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
    private static final DateTimeFormatter FORMATTER_DATE_TIME_TIME_ZONE_NAME_DAY = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);

    public static String toString(ZonedDateTime zonedDateTime) {
        try {
            return zonedDateTime.format(DateTimeFormatter.RFC_1123_DATE_TIME);
        }
        catch (Exception e) {
            log.error(UNABLE_TO_FORMAT_PROVIDED_ZONED_DATE_TIME, (Throwable)e);
            return null;
        }
    }

    public static String toStringNumericTimeZone(ZonedDateTime zonedDateTime) {
        try {
            return zonedDateTime.format(FORMATTER_DATE_TIME_PATTERN_TIME_ZONE);
        }
        catch (Exception e) {
            log.error(UNABLE_TO_FORMAT_PROVIDED_ZONED_DATE_TIME, (Throwable)e);
            return null;
        }
    }

    public static String toStringNameTimeZone(ZonedDateTime zonedDateTime) {
        try {
            return zonedDateTime.format(FORMATTER_DATE_TIME_TIME_ZONE_NAME_DAY);
        }
        catch (Exception e) {
            log.error(UNABLE_TO_FORMAT_PROVIDED_ZONED_DATE_TIME, (Throwable)e);
            return null;
        }
    }

    private DateTimeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

