/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.model.domains;

import com.mailgun.enums.SpamAction;
import com.mailgun.enums.WebScheme;
import feign.form.FormProperty;
import java.util.List;

public class DomainRequest {
    String name;
    @FormProperty(value="spam_action")
    String spamAction;
    Boolean wildcard;
    @FormProperty(value="force_dkim_authority")
    Boolean forceDkimAuthority;
    @FormProperty(value="dkim_key_size")
    Integer dkimKeySize;
    List<String> ips;
    @FormProperty(value="pool_id")
    String poolId;
    @FormProperty(value="web_scheme")
    String webScheme;

    DomainRequest(String name, String spamAction, Boolean wildcard, Boolean forceDkimAuthority, Integer dkimKeySize, List<String> ips, String poolId, String webScheme) {
        this.name = name;
        this.spamAction = spamAction;
        this.wildcard = wildcard;
        this.forceDkimAuthority = forceDkimAuthority;
        this.dkimKeySize = dkimKeySize;
        this.ips = ips;
        this.poolId = poolId;
        this.webScheme = webScheme;
    }

    public static DomainRequestBuilder builder() {
        return new DomainRequestBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getSpamAction() {
        return this.spamAction;
    }

    public Boolean getWildcard() {
        return this.wildcard;
    }

    public Boolean getForceDkimAuthority() {
        return this.forceDkimAuthority;
    }

    public Integer getDkimKeySize() {
        return this.dkimKeySize;
    }

    public List<String> getIps() {
        return this.ips;
    }

    public String getPoolId() {
        return this.poolId;
    }

    public String getWebScheme() {
        return this.webScheme;
    }

    public String toString() {
        return "DomainRequest(name=" + this.getName() + ", spamAction=" + this.getSpamAction() + ", wildcard=" + this.getWildcard() + ", forceDkimAuthority=" + this.getForceDkimAuthority() + ", dkimKeySize=" + this.getDkimKeySize() + ", ips=" + this.getIps() + ", poolId=" + this.getPoolId() + ", webScheme=" + this.getWebScheme() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DomainRequest)) {
            return false;
        }
        DomainRequest other = (DomainRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$wildcard = this.getWildcard();
        Boolean other$wildcard = other.getWildcard();
        if (this$wildcard == null ? other$wildcard != null : !((Object)this$wildcard).equals(other$wildcard)) {
            return false;
        }
        Boolean this$forceDkimAuthority = this.getForceDkimAuthority();
        Boolean other$forceDkimAuthority = other.getForceDkimAuthority();
        if (this$forceDkimAuthority == null ? other$forceDkimAuthority != null : !((Object)this$forceDkimAuthority).equals(other$forceDkimAuthority)) {
            return false;
        }
        Integer this$dkimKeySize = this.getDkimKeySize();
        Integer other$dkimKeySize = other.getDkimKeySize();
        if (this$dkimKeySize == null ? other$dkimKeySize != null : !((Object)this$dkimKeySize).equals(other$dkimKeySize)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$spamAction = this.getSpamAction();
        String other$spamAction = other.getSpamAction();
        if (this$spamAction == null ? other$spamAction != null : !this$spamAction.equals(other$spamAction)) {
            return false;
        }
        List<String> this$ips = this.getIps();
        List<String> other$ips = other.getIps();
        if (this$ips == null ? other$ips != null : !((Object)this$ips).equals(other$ips)) {
            return false;
        }
        String this$poolId = this.getPoolId();
        String other$poolId = other.getPoolId();
        if (this$poolId == null ? other$poolId != null : !this$poolId.equals(other$poolId)) {
            return false;
        }
        String this$webScheme = this.getWebScheme();
        String other$webScheme = other.getWebScheme();
        return !(this$webScheme == null ? other$webScheme != null : !this$webScheme.equals(other$webScheme));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DomainRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $wildcard = this.getWildcard();
        result = result * 59 + ($wildcard == null ? 43 : ((Object)$wildcard).hashCode());
        Boolean $forceDkimAuthority = this.getForceDkimAuthority();
        result = result * 59 + ($forceDkimAuthority == null ? 43 : ((Object)$forceDkimAuthority).hashCode());
        Integer $dkimKeySize = this.getDkimKeySize();
        result = result * 59 + ($dkimKeySize == null ? 43 : ((Object)$dkimKeySize).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $spamAction = this.getSpamAction();
        result = result * 59 + ($spamAction == null ? 43 : $spamAction.hashCode());
        List<String> $ips = this.getIps();
        result = result * 59 + ($ips == null ? 43 : ((Object)$ips).hashCode());
        String $poolId = this.getPoolId();
        result = result * 59 + ($poolId == null ? 43 : $poolId.hashCode());
        String $webScheme = this.getWebScheme();
        result = result * 59 + ($webScheme == null ? 43 : $webScheme.hashCode());
        return result;
    }

    public static class DomainRequestBuilder {
        private String name;
        private String spamAction;
        private Boolean wildcard;
        private Boolean forceDkimAuthority;
        private Integer dkimKeySize;
        private List<String> ips;
        private String poolId;
        private String webScheme;

        public DomainRequestBuilder spamAction(SpamAction spamAction) {
            this.spamAction = spamAction.getValue();
            return this;
        }

        public DomainRequestBuilder webScheme(WebScheme webScheme) {
            this.webScheme = webScheme.getValue();
            return this;
        }

        DomainRequestBuilder() {
        }

        public DomainRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DomainRequestBuilder wildcard(Boolean wildcard) {
            this.wildcard = wildcard;
            return this;
        }

        public DomainRequestBuilder forceDkimAuthority(Boolean forceDkimAuthority) {
            this.forceDkimAuthority = forceDkimAuthority;
            return this;
        }

        public DomainRequestBuilder dkimKeySize(Integer dkimKeySize) {
            this.dkimKeySize = dkimKeySize;
            return this;
        }

        public DomainRequestBuilder ips(List<String> ips) {
            this.ips = ips;
            return this;
        }

        public DomainRequestBuilder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public DomainRequest build() {
            return new DomainRequest(this.name, this.spamAction, this.wildcard, this.forceDkimAuthority, this.dkimKeySize, this.ips, this.poolId, this.webScheme);
        }

        public String toString() {
            return "DomainRequest.DomainRequestBuilder(name=" + this.name + ", spamAction=" + this.spamAction + ", wildcard=" + this.wildcard + ", forceDkimAuthority=" + this.forceDkimAuthority + ", dkimKeySize=" + this.dkimKeySize + ", ips=" + this.ips + ", poolId=" + this.poolId + ", webScheme=" + this.webScheme + ")";
        }
    }
}

