/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.model.mailing.lists;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mailgun.enums.AccessLevel;
import com.mailgun.enums.ReplyPreference;
import java.time.ZonedDateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=MailingListDataBuilder.class)
public final class MailingListData {
    @JsonProperty(value="access_level")
    private final AccessLevel accessLevel;
    private final String address;
    @JsonFormat(pattern="EEE, dd MMM yyyy HH:mm:ss Z", locale="en")
    @JsonProperty(value="created_at")
    private final ZonedDateTime createdAt;
    private final String description;
    @JsonProperty(value="members_count")
    private final Integer membersCount;
    private final String name;
    @JsonProperty(value="reply_preference")
    private final ReplyPreference replyPreference;

    MailingListData(AccessLevel accessLevel, String address, ZonedDateTime createdAt, String description, Integer membersCount, String name, ReplyPreference replyPreference) {
        this.accessLevel = accessLevel;
        this.address = address;
        this.createdAt = createdAt;
        this.description = description;
        this.membersCount = membersCount;
        this.name = name;
        this.replyPreference = replyPreference;
    }

    public static MailingListDataBuilder builder() {
        return new MailingListDataBuilder();
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public String getAddress() {
        return this.address;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getMembersCount() {
        return this.membersCount;
    }

    public String getName() {
        return this.name;
    }

    public ReplyPreference getReplyPreference() {
        return this.replyPreference;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MailingListData)) {
            return false;
        }
        MailingListData other = (MailingListData)o;
        Integer this$membersCount = this.getMembersCount();
        Integer other$membersCount = other.getMembersCount();
        if (this$membersCount == null ? other$membersCount != null : !((Object)this$membersCount).equals(other$membersCount)) {
            return false;
        }
        AccessLevel this$accessLevel = this.getAccessLevel();
        AccessLevel other$accessLevel = other.getAccessLevel();
        if (this$accessLevel == null ? other$accessLevel != null : !((Object)((Object)this$accessLevel)).equals((Object)other$accessLevel)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        ZonedDateTime this$createdAt = this.getCreatedAt();
        ZonedDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ReplyPreference this$replyPreference = this.getReplyPreference();
        ReplyPreference other$replyPreference = other.getReplyPreference();
        return !(this$replyPreference == null ? other$replyPreference != null : !((Object)((Object)this$replyPreference)).equals((Object)other$replyPreference));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $membersCount = this.getMembersCount();
        result = result * 59 + ($membersCount == null ? 43 : ((Object)$membersCount).hashCode());
        AccessLevel $accessLevel = this.getAccessLevel();
        result = result * 59 + ($accessLevel == null ? 43 : ((Object)((Object)$accessLevel)).hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        ZonedDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ReplyPreference $replyPreference = this.getReplyPreference();
        result = result * 59 + ($replyPreference == null ? 43 : ((Object)((Object)$replyPreference)).hashCode());
        return result;
    }

    public String toString() {
        return "MailingListData(accessLevel=" + (Object)((Object)this.getAccessLevel()) + ", address=" + this.getAddress() + ", createdAt=" + this.getCreatedAt() + ", description=" + this.getDescription() + ", membersCount=" + this.getMembersCount() + ", name=" + this.getName() + ", replyPreference=" + (Object)((Object)this.getReplyPreference()) + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class MailingListDataBuilder {
        private AccessLevel accessLevel;
        private String address;
        private ZonedDateTime createdAt;
        private String description;
        private Integer membersCount;
        private String name;
        private ReplyPreference replyPreference;

        MailingListDataBuilder() {
        }

        @JsonProperty(value="access_level")
        public MailingListDataBuilder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public MailingListDataBuilder address(String address) {
            this.address = address;
            return this;
        }

        @JsonFormat(pattern="EEE, dd MMM yyyy HH:mm:ss Z", locale="en")
        @JsonProperty(value="created_at")
        public MailingListDataBuilder createdAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public MailingListDataBuilder description(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="members_count")
        public MailingListDataBuilder membersCount(Integer membersCount) {
            this.membersCount = membersCount;
            return this;
        }

        public MailingListDataBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="reply_preference")
        public MailingListDataBuilder replyPreference(ReplyPreference replyPreference) {
            this.replyPreference = replyPreference;
            return this;
        }

        public MailingListData build() {
            return new MailingListData(this.accessLevel, this.address, this.createdAt, this.description, this.membersCount, this.name, this.replyPreference);
        }

        public String toString() {
            return "MailingListData.MailingListDataBuilder(accessLevel=" + (Object)((Object)this.accessLevel) + ", address=" + this.address + ", createdAt=" + this.createdAt + ", description=" + this.description + ", membersCount=" + this.membersCount + ", name=" + this.name + ", replyPreference=" + (Object)((Object)this.replyPreference) + ")";
        }
    }
}

