/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.model.mailing.lists;

import com.mailgun.enums.AccessLevel;
import com.mailgun.enums.ReplyPreference;
import feign.form.FormProperty;

public class MailingListRequest {
    String address;
    String name;
    String description;
    @FormProperty(value="access_level")
    String accessLevel;
    @FormProperty(value="reply_preference")
    String replyPreference;

    MailingListRequest(String address, String name, String description, String accessLevel, String replyPreference) {
        this.address = address;
        this.name = name;
        this.description = description;
        this.accessLevel = accessLevel;
        this.replyPreference = replyPreference;
    }

    public static MailingListRequestBuilder builder() {
        return new MailingListRequestBuilder();
    }

    public String getAddress() {
        return this.address;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAccessLevel() {
        return this.accessLevel;
    }

    public String getReplyPreference() {
        return this.replyPreference;
    }

    public String toString() {
        return "MailingListRequest(address=" + this.getAddress() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", accessLevel=" + this.getAccessLevel() + ", replyPreference=" + this.getReplyPreference() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MailingListRequest)) {
            return false;
        }
        MailingListRequest other = (MailingListRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$accessLevel = this.getAccessLevel();
        String other$accessLevel = other.getAccessLevel();
        if (this$accessLevel == null ? other$accessLevel != null : !this$accessLevel.equals(other$accessLevel)) {
            return false;
        }
        String this$replyPreference = this.getReplyPreference();
        String other$replyPreference = other.getReplyPreference();
        return !(this$replyPreference == null ? other$replyPreference != null : !this$replyPreference.equals(other$replyPreference));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MailingListRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $accessLevel = this.getAccessLevel();
        result = result * 59 + ($accessLevel == null ? 43 : $accessLevel.hashCode());
        String $replyPreference = this.getReplyPreference();
        result = result * 59 + ($replyPreference == null ? 43 : $replyPreference.hashCode());
        return result;
    }

    public static class MailingListRequestBuilder {
        private String address;
        private String name;
        private String description;
        private String accessLevel;
        private String replyPreference;

        public MailingListRequestBuilder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel.getValue();
            return this;
        }

        public MailingListRequestBuilder replyPreference(ReplyPreference replyPreference) {
            this.replyPreference = replyPreference.getValue();
            return this;
        }

        MailingListRequestBuilder() {
        }

        public MailingListRequestBuilder address(String address) {
            this.address = address;
            return this;
        }

        public MailingListRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MailingListRequestBuilder description(String description) {
            this.description = description;
            return this;
        }

        public MailingListRequest build() {
            return new MailingListRequest(this.address, this.name, this.description, this.accessLevel, this.replyPreference);
        }

        public String toString() {
            return "MailingListRequest.MailingListRequestBuilder(address=" + this.address + ", name=" + this.name + ", description=" + this.description + ", accessLevel=" + this.accessLevel + ", replyPreference=" + this.replyPreference + ")";
        }
    }
}

