/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.model.message;

import com.mailgun.enums.YesNo;
import com.mailgun.enums.YesNoHtml;
import com.mailgun.util.CollectionUtil;
import com.mailgun.util.DateTimeUtil;
import com.mailgun.util.StringUtil;
import feign.form.FormData;
import feign.form.FormProperty;
import java.io.File;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class Message {
    String from;
    Set<String> to;
    Set<String> cc;
    Set<String> bcc;
    String subject;
    String text;
    String html;
    Set<File> attachment;
    @FormProperty(value="attachment")
    Set<FormData> formData;
    Set<File> inline;
    String template;
    @FormProperty(value="t:version")
    String templateVersion;
    @FormProperty(value="t:text")
    String renderTemplate;
    @FormProperty(value="o:tag")
    Set<String> tag;
    @FormProperty(value="o:dkim")
    String dkim;
    @FormProperty(value="o:deliverytime")
    String deliveryTime;
    @FormProperty(value="o:testmode")
    String testMode;
    @FormProperty(value="o:tracking")
    String tracking;
    @FormProperty(value="o:tracking-clicks")
    String trackingClicks;
    @FormProperty(value="o:tracking-opens")
    String trackingOpens;
    @FormProperty(value="o:require-tls")
    String requireTls;
    @FormProperty(value="o:skip-verification")
    String skipVerification;
    @FormProperty(value="h:Reply-To")
    String replyTo;
    @FormProperty(value="recipient-variables")
    String recipientVariables;
    @FormProperty(value="v:my-var")
    String myVar;
    @FormProperty(value="t:variables")
    String mailgunVariables;

    public static MessageBuilder builder() {
        return new CustomMessageBuilder();
    }

    Message(String from, Set<String> to, Set<String> cc, Set<String> bcc, String subject, String text, String html, Set<File> attachment, Set<FormData> formData, Set<File> inline, String template, String templateVersion, String renderTemplate, Set<String> tag, String dkim, String deliveryTime, String testMode, String tracking, String trackingClicks, String trackingOpens, String requireTls, String skipVerification, String replyTo, String recipientVariables, String myVar, String mailgunVariables) {
        this.from = from;
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.subject = subject;
        this.text = text;
        this.html = html;
        this.attachment = attachment;
        this.formData = formData;
        this.inline = inline;
        this.template = template;
        this.templateVersion = templateVersion;
        this.renderTemplate = renderTemplate;
        this.tag = tag;
        this.dkim = dkim;
        this.deliveryTime = deliveryTime;
        this.testMode = testMode;
        this.tracking = tracking;
        this.trackingClicks = trackingClicks;
        this.trackingOpens = trackingOpens;
        this.requireTls = requireTls;
        this.skipVerification = skipVerification;
        this.replyTo = replyTo;
        this.recipientVariables = recipientVariables;
        this.myVar = myVar;
        this.mailgunVariables = mailgunVariables;
    }

    public String getFrom() {
        return this.from;
    }

    public Set<String> getTo() {
        return this.to;
    }

    public Set<String> getCc() {
        return this.cc;
    }

    public Set<String> getBcc() {
        return this.bcc;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getText() {
        return this.text;
    }

    public String getHtml() {
        return this.html;
    }

    public Set<File> getAttachment() {
        return this.attachment;
    }

    public Set<FormData> getFormData() {
        return this.formData;
    }

    public Set<File> getInline() {
        return this.inline;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getTemplateVersion() {
        return this.templateVersion;
    }

    public String getRenderTemplate() {
        return this.renderTemplate;
    }

    public Set<String> getTag() {
        return this.tag;
    }

    public String getDkim() {
        return this.dkim;
    }

    public String getDeliveryTime() {
        return this.deliveryTime;
    }

    public String getTestMode() {
        return this.testMode;
    }

    public String getTracking() {
        return this.tracking;
    }

    public String getTrackingClicks() {
        return this.trackingClicks;
    }

    public String getTrackingOpens() {
        return this.trackingOpens;
    }

    public String getRequireTls() {
        return this.requireTls;
    }

    public String getSkipVerification() {
        return this.skipVerification;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public String getRecipientVariables() {
        return this.recipientVariables;
    }

    public String getMyVar() {
        return this.myVar;
    }

    public String getMailgunVariables() {
        return this.mailgunVariables;
    }

    public String toString() {
        return "Message(from=" + this.getFrom() + ", to=" + this.getTo() + ", cc=" + this.getCc() + ", bcc=" + this.getBcc() + ", subject=" + this.getSubject() + ", text=" + this.getText() + ", html=" + this.getHtml() + ", attachment=" + this.getAttachment() + ", formData=" + this.getFormData() + ", inline=" + this.getInline() + ", template=" + this.getTemplate() + ", templateVersion=" + this.getTemplateVersion() + ", renderTemplate=" + this.getRenderTemplate() + ", tag=" + this.getTag() + ", dkim=" + this.getDkim() + ", deliveryTime=" + this.getDeliveryTime() + ", testMode=" + this.getTestMode() + ", tracking=" + this.getTracking() + ", trackingClicks=" + this.getTrackingClicks() + ", trackingOpens=" + this.getTrackingOpens() + ", requireTls=" + this.getRequireTls() + ", skipVerification=" + this.getSkipVerification() + ", replyTo=" + this.getReplyTo() + ", recipientVariables=" + this.getRecipientVariables() + ", myVar=" + this.getMyVar() + ", mailgunVariables=" + this.getMailgunVariables() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        Set<String> this$to = this.getTo();
        Set<String> other$to = other.getTo();
        if (this$to == null ? other$to != null : !((Object)this$to).equals(other$to)) {
            return false;
        }
        Set<String> this$cc = this.getCc();
        Set<String> other$cc = other.getCc();
        if (this$cc == null ? other$cc != null : !((Object)this$cc).equals(other$cc)) {
            return false;
        }
        Set<String> this$bcc = this.getBcc();
        Set<String> other$bcc = other.getBcc();
        if (this$bcc == null ? other$bcc != null : !((Object)this$bcc).equals(other$bcc)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$html = this.getHtml();
        String other$html = other.getHtml();
        if (this$html == null ? other$html != null : !this$html.equals(other$html)) {
            return false;
        }
        Set<File> this$attachment = this.getAttachment();
        Set<File> other$attachment = other.getAttachment();
        if (this$attachment == null ? other$attachment != null : !((Object)this$attachment).equals(other$attachment)) {
            return false;
        }
        Set<FormData> this$formData = this.getFormData();
        Set<FormData> other$formData = other.getFormData();
        if (this$formData == null ? other$formData != null : !((Object)this$formData).equals(other$formData)) {
            return false;
        }
        Set<File> this$inline = this.getInline();
        Set<File> other$inline = other.getInline();
        if (this$inline == null ? other$inline != null : !((Object)this$inline).equals(other$inline)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        String this$templateVersion = this.getTemplateVersion();
        String other$templateVersion = other.getTemplateVersion();
        if (this$templateVersion == null ? other$templateVersion != null : !this$templateVersion.equals(other$templateVersion)) {
            return false;
        }
        String this$renderTemplate = this.getRenderTemplate();
        String other$renderTemplate = other.getRenderTemplate();
        if (this$renderTemplate == null ? other$renderTemplate != null : !this$renderTemplate.equals(other$renderTemplate)) {
            return false;
        }
        Set<String> this$tag = this.getTag();
        Set<String> other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !((Object)this$tag).equals(other$tag)) {
            return false;
        }
        String this$dkim = this.getDkim();
        String other$dkim = other.getDkim();
        if (this$dkim == null ? other$dkim != null : !this$dkim.equals(other$dkim)) {
            return false;
        }
        String this$deliveryTime = this.getDeliveryTime();
        String other$deliveryTime = other.getDeliveryTime();
        if (this$deliveryTime == null ? other$deliveryTime != null : !this$deliveryTime.equals(other$deliveryTime)) {
            return false;
        }
        String this$testMode = this.getTestMode();
        String other$testMode = other.getTestMode();
        if (this$testMode == null ? other$testMode != null : !this$testMode.equals(other$testMode)) {
            return false;
        }
        String this$tracking = this.getTracking();
        String other$tracking = other.getTracking();
        if (this$tracking == null ? other$tracking != null : !this$tracking.equals(other$tracking)) {
            return false;
        }
        String this$trackingClicks = this.getTrackingClicks();
        String other$trackingClicks = other.getTrackingClicks();
        if (this$trackingClicks == null ? other$trackingClicks != null : !this$trackingClicks.equals(other$trackingClicks)) {
            return false;
        }
        String this$trackingOpens = this.getTrackingOpens();
        String other$trackingOpens = other.getTrackingOpens();
        if (this$trackingOpens == null ? other$trackingOpens != null : !this$trackingOpens.equals(other$trackingOpens)) {
            return false;
        }
        String this$requireTls = this.getRequireTls();
        String other$requireTls = other.getRequireTls();
        if (this$requireTls == null ? other$requireTls != null : !this$requireTls.equals(other$requireTls)) {
            return false;
        }
        String this$skipVerification = this.getSkipVerification();
        String other$skipVerification = other.getSkipVerification();
        if (this$skipVerification == null ? other$skipVerification != null : !this$skipVerification.equals(other$skipVerification)) {
            return false;
        }
        String this$replyTo = this.getReplyTo();
        String other$replyTo = other.getReplyTo();
        if (this$replyTo == null ? other$replyTo != null : !this$replyTo.equals(other$replyTo)) {
            return false;
        }
        String this$recipientVariables = this.getRecipientVariables();
        String other$recipientVariables = other.getRecipientVariables();
        if (this$recipientVariables == null ? other$recipientVariables != null : !this$recipientVariables.equals(other$recipientVariables)) {
            return false;
        }
        String this$myVar = this.getMyVar();
        String other$myVar = other.getMyVar();
        if (this$myVar == null ? other$myVar != null : !this$myVar.equals(other$myVar)) {
            return false;
        }
        String this$mailgunVariables = this.getMailgunVariables();
        String other$mailgunVariables = other.getMailgunVariables();
        return !(this$mailgunVariables == null ? other$mailgunVariables != null : !this$mailgunVariables.equals(other$mailgunVariables));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        Set<String> $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
        Set<String> $cc = this.getCc();
        result = result * 59 + ($cc == null ? 43 : ((Object)$cc).hashCode());
        Set<String> $bcc = this.getBcc();
        result = result * 59 + ($bcc == null ? 43 : ((Object)$bcc).hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $html = this.getHtml();
        result = result * 59 + ($html == null ? 43 : $html.hashCode());
        Set<File> $attachment = this.getAttachment();
        result = result * 59 + ($attachment == null ? 43 : ((Object)$attachment).hashCode());
        Set<FormData> $formData = this.getFormData();
        result = result * 59 + ($formData == null ? 43 : ((Object)$formData).hashCode());
        Set<File> $inline = this.getInline();
        result = result * 59 + ($inline == null ? 43 : ((Object)$inline).hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        String $templateVersion = this.getTemplateVersion();
        result = result * 59 + ($templateVersion == null ? 43 : $templateVersion.hashCode());
        String $renderTemplate = this.getRenderTemplate();
        result = result * 59 + ($renderTemplate == null ? 43 : $renderTemplate.hashCode());
        Set<String> $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : ((Object)$tag).hashCode());
        String $dkim = this.getDkim();
        result = result * 59 + ($dkim == null ? 43 : $dkim.hashCode());
        String $deliveryTime = this.getDeliveryTime();
        result = result * 59 + ($deliveryTime == null ? 43 : $deliveryTime.hashCode());
        String $testMode = this.getTestMode();
        result = result * 59 + ($testMode == null ? 43 : $testMode.hashCode());
        String $tracking = this.getTracking();
        result = result * 59 + ($tracking == null ? 43 : $tracking.hashCode());
        String $trackingClicks = this.getTrackingClicks();
        result = result * 59 + ($trackingClicks == null ? 43 : $trackingClicks.hashCode());
        String $trackingOpens = this.getTrackingOpens();
        result = result * 59 + ($trackingOpens == null ? 43 : $trackingOpens.hashCode());
        String $requireTls = this.getRequireTls();
        result = result * 59 + ($requireTls == null ? 43 : $requireTls.hashCode());
        String $skipVerification = this.getSkipVerification();
        result = result * 59 + ($skipVerification == null ? 43 : $skipVerification.hashCode());
        String $replyTo = this.getReplyTo();
        result = result * 59 + ($replyTo == null ? 43 : $replyTo.hashCode());
        String $recipientVariables = this.getRecipientVariables();
        result = result * 59 + ($recipientVariables == null ? 43 : $recipientVariables.hashCode());
        String $myVar = this.getMyVar();
        result = result * 59 + ($myVar == null ? 43 : $myVar.hashCode());
        String $mailgunVariables = this.getMailgunVariables();
        result = result * 59 + ($mailgunVariables == null ? 43 : $mailgunVariables.hashCode());
        return result;
    }

    public static class MessageBuilder {
        private String from;
        private Set<String> to;
        private Set<String> cc;
        private Set<String> bcc;
        private String subject;
        private String text;
        private String html;
        private Set<File> attachment;
        private Set<FormData> formData;
        private Set<File> inline;
        private String template;
        private String templateVersion;
        private String renderTemplate;
        private Set<String> tag;
        private String dkim;
        private String deliveryTime;
        private String testMode;
        private String tracking;
        private String trackingClicks;
        private String trackingOpens;
        private String requireTls;
        private String skipVerification;
        private String replyTo;
        private String recipientVariables;
        private String myVar;
        private String mailgunVariables;

        public MessageBuilder to(String to) {
            this.to = CollectionUtil.addToSet(this.to, to);
            return this;
        }

        public MessageBuilder to(List<String> to) {
            this.to = CollectionUtil.addToSet(this.to, to);
            return this;
        }

        public MessageBuilder cc(String cc) {
            this.cc = CollectionUtil.addToSet(this.cc, cc);
            return this;
        }

        public MessageBuilder cc(List<String> cc) {
            this.cc = CollectionUtil.addToSet(this.cc, cc);
            return this;
        }

        public MessageBuilder bcc(String bcc) {
            this.bcc = CollectionUtil.addToSet(this.bcc, bcc);
            return this;
        }

        public MessageBuilder bcc(List<String> bcc) {
            this.bcc = CollectionUtil.addToSet(this.bcc, bcc);
            return this;
        }

        public MessageBuilder attachment(File attachment) {
            this.attachment = CollectionUtil.addToSet(this.attachment, attachment);
            return this;
        }

        public MessageBuilder attachment(List<File> attachments) {
            this.attachment = CollectionUtil.addToSet(this.attachment, attachments);
            return this;
        }

        public MessageBuilder formData(FormData attachment) {
            this.formData = CollectionUtil.addToSet(this.formData, attachment);
            return this;
        }

        public MessageBuilder formData(List<FormData> attachments) {
            this.formData = CollectionUtil.addToSet(this.formData, attachments);
            return this;
        }

        public MessageBuilder inline(File attachment) {
            this.inline = CollectionUtil.addToSet(this.inline, attachment);
            return this;
        }

        public MessageBuilder inline(List<File> attachments) {
            this.inline = CollectionUtil.addToSet(this.inline, attachments);
            return this;
        }

        public MessageBuilder renderTemplate(boolean renderTemplate) {
            if (renderTemplate) {
                this.renderTemplate = YesNo.YES.getValue();
            }
            return this;
        }

        public MessageBuilder tag(String tag) {
            this.tag = CollectionUtil.addToSet(this.tag, tag);
            return this;
        }

        public MessageBuilder tag(List<String> tags) {
            this.tag = CollectionUtil.addToSet(this.tag, tags);
            return this;
        }

        public MessageBuilder dkim(boolean enableDKIM) {
            this.dkim = YesNo.getValue(enableDKIM);
            return this;
        }

        public MessageBuilder deliveryTime(ZonedDateTime deliveryTime) {
            this.deliveryTime = DateTimeUtil.toString(deliveryTime);
            return this;
        }

        public MessageBuilder testMode(boolean enableSendingInTestMode) {
            if (enableSendingInTestMode) {
                this.testMode = YesNo.YES.getValue();
            }
            return this;
        }

        public MessageBuilder tracking(boolean toggleTracking) {
            this.tracking = YesNo.getValue(toggleTracking);
            return this;
        }

        public MessageBuilder trackingClicks(YesNoHtml yesNoHtml) {
            this.trackingClicks = yesNoHtml.getValue();
            return this;
        }

        public MessageBuilder trackingOpens(boolean toggleOpensTracking) {
            this.trackingOpens = YesNo.getValue(toggleOpensTracking);
            return this;
        }

        public MessageBuilder requireTls(boolean requireTLS) {
            this.requireTls = YesNo.getValue(requireTLS);
            return this;
        }

        public MessageBuilder skipVerification(boolean skipVerification) {
            this.skipVerification = YesNo.getValue(skipVerification);
            return this;
        }

        public MessageBuilder replyTo(String replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public MessageBuilder recipientVariables(Map<String, Object> recipientVariables) {
            this.recipientVariables = StringUtil.asJsonString(recipientVariables);
            return this;
        }

        public MessageBuilder recipientVariables(String recipientVariables) {
            this.recipientVariables = recipientVariables;
            return this;
        }

        public MessageBuilder myVar(Map<String, Object> myVar) {
            this.myVar = StringUtil.asJsonString(myVar);
            return this;
        }

        public MessageBuilder myVar(String myVar) {
            this.myVar = myVar;
            return this;
        }

        public MessageBuilder mailgunVariables(Map<String, Object> mailgunVariables) {
            this.mailgunVariables = StringUtil.asJsonString(mailgunVariables);
            return this;
        }

        public MessageBuilder mailgunVariables(String mailgunVariables) {
            this.mailgunVariables = mailgunVariables;
            return this;
        }

        MessageBuilder() {
        }

        public MessageBuilder from(String from) {
            this.from = from;
            return this;
        }

        public MessageBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public MessageBuilder text(String text) {
            this.text = text;
            return this;
        }

        public MessageBuilder html(String html) {
            this.html = html;
            return this;
        }

        public MessageBuilder template(String template) {
            this.template = template;
            return this;
        }

        public MessageBuilder templateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
            return this;
        }

        public Message build() {
            return new Message(this.from, this.to, this.cc, this.bcc, this.subject, this.text, this.html, this.attachment, this.formData, this.inline, this.template, this.templateVersion, this.renderTemplate, this.tag, this.dkim, this.deliveryTime, this.testMode, this.tracking, this.trackingClicks, this.trackingOpens, this.requireTls, this.skipVerification, this.replyTo, this.recipientVariables, this.myVar, this.mailgunVariables);
        }

        public String toString() {
            return "Message.MessageBuilder(from=" + this.from + ", to=" + this.to + ", cc=" + this.cc + ", bcc=" + this.bcc + ", subject=" + this.subject + ", text=" + this.text + ", html=" + this.html + ", attachment=" + this.attachment + ", formData=" + this.formData + ", inline=" + this.inline + ", template=" + this.template + ", templateVersion=" + this.templateVersion + ", renderTemplate=" + this.renderTemplate + ", tag=" + this.tag + ", dkim=" + this.dkim + ", deliveryTime=" + this.deliveryTime + ", testMode=" + this.testMode + ", tracking=" + this.tracking + ", trackingClicks=" + this.trackingClicks + ", trackingOpens=" + this.trackingOpens + ", requireTls=" + this.requireTls + ", skipVerification=" + this.skipVerification + ", replyTo=" + this.replyTo + ", recipientVariables=" + this.recipientVariables + ", myVar=" + this.myVar + ", mailgunVariables=" + this.mailgunVariables + ")";
        }
    }

    private static class CustomMessageBuilder
    extends MessageBuilder {
        private CustomMessageBuilder() {
        }

        @Override
        public Message build() {
            if (StringUtils.isBlank((CharSequence)((MessageBuilder)this).from)) {
                throw new IllegalArgumentException(String.format("Field '%s' cannot be null or empty!", "from"));
            }
            if (CollectionUtils.isEmpty((Collection)((MessageBuilder)this).to)) {
                throw new IllegalArgumentException(String.format("Field '%s' cannot be null or empty!", "to"));
            }
            ((MessageBuilder)this).to.stream().filter(StringUtils::isNotBlank).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Field '%s' cannot be null or empty!", "to")));
            if (CollectionUtils.isNotEmpty((Collection)((MessageBuilder)this).attachment) && CollectionUtils.isNotEmpty((Collection)((MessageBuilder)this).formData)) {
                throw new IllegalArgumentException("You cannot use 'attachment' and 'formData' together");
            }
            return super.build();
        }
    }
}

