/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.model.message;

import com.mailgun.util.CollectionUtil;
import com.mailgun.util.StringUtil;
import feign.form.FormProperty;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MailgunMimeMessage {
    Set<String> to;
    File message;
    @FormProperty(value="o:tag")
    Set<String> tag;
    @FormProperty(value="o:deliverytime")
    String deliveryTime;
    @FormProperty(value="o:dkim")
    String dkim;
    @FormProperty(value="o:testmode")
    String testMode;
    @FormProperty(value="o:tracking")
    String tracking;
    @FormProperty(value="o:tracking-clicks")
    String trackingClicks;
    @FormProperty(value="o:tracking-opens")
    String trackingOpens;
    @FormProperty(value="h:Reply-To")
    String replyTo;
    @FormProperty(value="v:my-var")
    String myVar;

    MailgunMimeMessage(Set<String> to, File message, Set<String> tag, String deliveryTime, String dkim, String testMode, String tracking, String trackingClicks, String trackingOpens, String replyTo, String myVar) {
        this.to = to;
        this.message = message;
        this.tag = tag;
        this.deliveryTime = deliveryTime;
        this.dkim = dkim;
        this.testMode = testMode;
        this.tracking = tracking;
        this.trackingClicks = trackingClicks;
        this.trackingOpens = trackingOpens;
        this.replyTo = replyTo;
        this.myVar = myVar;
    }

    public static MailgunMimeMessageBuilder builder() {
        return new MailgunMimeMessageBuilder();
    }

    public Set<String> getTo() {
        return this.to;
    }

    public File getMessage() {
        return this.message;
    }

    public Set<String> getTag() {
        return this.tag;
    }

    public String getDeliveryTime() {
        return this.deliveryTime;
    }

    public String getDkim() {
        return this.dkim;
    }

    public String getTestMode() {
        return this.testMode;
    }

    public String getTracking() {
        return this.tracking;
    }

    public String getTrackingClicks() {
        return this.trackingClicks;
    }

    public String getTrackingOpens() {
        return this.trackingOpens;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public String getMyVar() {
        return this.myVar;
    }

    public String toString() {
        return "MailgunMimeMessage(to=" + this.getTo() + ", message=" + this.getMessage() + ", tag=" + this.getTag() + ", deliveryTime=" + this.getDeliveryTime() + ", dkim=" + this.getDkim() + ", testMode=" + this.getTestMode() + ", tracking=" + this.getTracking() + ", trackingClicks=" + this.getTrackingClicks() + ", trackingOpens=" + this.getTrackingOpens() + ", replyTo=" + this.getReplyTo() + ", myVar=" + this.getMyVar() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MailgunMimeMessage)) {
            return false;
        }
        MailgunMimeMessage other = (MailgunMimeMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$to = this.getTo();
        Set<String> other$to = other.getTo();
        if (this$to == null ? other$to != null : !((Object)this$to).equals(other$to)) {
            return false;
        }
        File this$message = this.getMessage();
        File other$message = other.getMessage();
        if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
            return false;
        }
        Set<String> this$tag = this.getTag();
        Set<String> other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !((Object)this$tag).equals(other$tag)) {
            return false;
        }
        String this$deliveryTime = this.getDeliveryTime();
        String other$deliveryTime = other.getDeliveryTime();
        if (this$deliveryTime == null ? other$deliveryTime != null : !this$deliveryTime.equals(other$deliveryTime)) {
            return false;
        }
        String this$dkim = this.getDkim();
        String other$dkim = other.getDkim();
        if (this$dkim == null ? other$dkim != null : !this$dkim.equals(other$dkim)) {
            return false;
        }
        String this$testMode = this.getTestMode();
        String other$testMode = other.getTestMode();
        if (this$testMode == null ? other$testMode != null : !this$testMode.equals(other$testMode)) {
            return false;
        }
        String this$tracking = this.getTracking();
        String other$tracking = other.getTracking();
        if (this$tracking == null ? other$tracking != null : !this$tracking.equals(other$tracking)) {
            return false;
        }
        String this$trackingClicks = this.getTrackingClicks();
        String other$trackingClicks = other.getTrackingClicks();
        if (this$trackingClicks == null ? other$trackingClicks != null : !this$trackingClicks.equals(other$trackingClicks)) {
            return false;
        }
        String this$trackingOpens = this.getTrackingOpens();
        String other$trackingOpens = other.getTrackingOpens();
        if (this$trackingOpens == null ? other$trackingOpens != null : !this$trackingOpens.equals(other$trackingOpens)) {
            return false;
        }
        String this$replyTo = this.getReplyTo();
        String other$replyTo = other.getReplyTo();
        if (this$replyTo == null ? other$replyTo != null : !this$replyTo.equals(other$replyTo)) {
            return false;
        }
        String this$myVar = this.getMyVar();
        String other$myVar = other.getMyVar();
        return !(this$myVar == null ? other$myVar != null : !this$myVar.equals(other$myVar));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MailgunMimeMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
        File $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        Set<String> $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : ((Object)$tag).hashCode());
        String $deliveryTime = this.getDeliveryTime();
        result = result * 59 + ($deliveryTime == null ? 43 : $deliveryTime.hashCode());
        String $dkim = this.getDkim();
        result = result * 59 + ($dkim == null ? 43 : $dkim.hashCode());
        String $testMode = this.getTestMode();
        result = result * 59 + ($testMode == null ? 43 : $testMode.hashCode());
        String $tracking = this.getTracking();
        result = result * 59 + ($tracking == null ? 43 : $tracking.hashCode());
        String $trackingClicks = this.getTrackingClicks();
        result = result * 59 + ($trackingClicks == null ? 43 : $trackingClicks.hashCode());
        String $trackingOpens = this.getTrackingOpens();
        result = result * 59 + ($trackingOpens == null ? 43 : $trackingOpens.hashCode());
        String $replyTo = this.getReplyTo();
        result = result * 59 + ($replyTo == null ? 43 : $replyTo.hashCode());
        String $myVar = this.getMyVar();
        result = result * 59 + ($myVar == null ? 43 : $myVar.hashCode());
        return result;
    }

    public static class MailgunMimeMessageBuilder {
        private Set<String> to;
        private File message;
        private Set<String> tag;
        private String deliveryTime;
        private String dkim;
        private String testMode;
        private String tracking;
        private String trackingClicks;
        private String trackingOpens;
        private String replyTo;
        private String myVar;

        public MailgunMimeMessageBuilder to(String to) {
            this.to = CollectionUtil.addToSet(this.to, to);
            return this;
        }

        public MailgunMimeMessageBuilder to(List<String> to) {
            this.to = CollectionUtil.addToSet(this.to, to);
            return this;
        }

        public MailgunMimeMessageBuilder myVar(Map<String, Object> myVar) {
            this.myVar = StringUtil.asJsonString(myVar);
            return this;
        }

        MailgunMimeMessageBuilder() {
        }

        public MailgunMimeMessageBuilder message(File message) {
            this.message = message;
            return this;
        }

        public MailgunMimeMessageBuilder tag(Set<String> tag) {
            this.tag = tag;
            return this;
        }

        public MailgunMimeMessageBuilder deliveryTime(String deliveryTime) {
            this.deliveryTime = deliveryTime;
            return this;
        }

        public MailgunMimeMessageBuilder dkim(String dkim) {
            this.dkim = dkim;
            return this;
        }

        public MailgunMimeMessageBuilder testMode(String testMode) {
            this.testMode = testMode;
            return this;
        }

        public MailgunMimeMessageBuilder tracking(String tracking) {
            this.tracking = tracking;
            return this;
        }

        public MailgunMimeMessageBuilder trackingClicks(String trackingClicks) {
            this.trackingClicks = trackingClicks;
            return this;
        }

        public MailgunMimeMessageBuilder trackingOpens(String trackingOpens) {
            this.trackingOpens = trackingOpens;
            return this;
        }

        public MailgunMimeMessageBuilder replyTo(String replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public MailgunMimeMessage build() {
            return new MailgunMimeMessage(this.to, this.message, this.tag, this.deliveryTime, this.dkim, this.testMode, this.tracking, this.trackingClicks, this.trackingOpens, this.replyTo, this.myVar);
        }

        public String toString() {
            return "MailgunMimeMessage.MailgunMimeMessageBuilder(to=" + this.to + ", message=" + this.message + ", tag=" + this.tag + ", deliveryTime=" + this.deliveryTime + ", dkim=" + this.dkim + ", testMode=" + this.testMode + ", tracking=" + this.tracking + ", trackingClicks=" + this.trackingClicks + ", trackingOpens=" + this.trackingOpens + ", replyTo=" + this.replyTo + ", myVar=" + this.myVar + ")";
        }
    }
}

