/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.model.webhooks;

import com.mailgun.enums.WebhookName;
import feign.form.FormProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class WebhookRequest {
    @FormProperty(value="id")
    String webhookName;
    @FormProperty(value="url")
    Set<String> urls;

    public static WebhookRequestBuilder builder() {
        return new CustomWebhookRequestBuilder();
    }

    WebhookRequest(String webhookName, Set<String> urls) {
        this.webhookName = webhookName;
        this.urls = urls;
    }

    public String getWebhookName() {
        return this.webhookName;
    }

    public Set<String> getUrls() {
        return this.urls;
    }

    public String toString() {
        return "WebhookRequest(webhookName=" + this.getWebhookName() + ", urls=" + this.getUrls() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebhookRequest)) {
            return false;
        }
        WebhookRequest other = (WebhookRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$webhookName = this.getWebhookName();
        String other$webhookName = other.getWebhookName();
        if (this$webhookName == null ? other$webhookName != null : !this$webhookName.equals(other$webhookName)) {
            return false;
        }
        Set<String> this$urls = this.getUrls();
        Set<String> other$urls = other.getUrls();
        return !(this$urls == null ? other$urls != null : !((Object)this$urls).equals(other$urls));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebhookRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $webhookName = this.getWebhookName();
        result = result * 59 + ($webhookName == null ? 43 : $webhookName.hashCode());
        Set<String> $urls = this.getUrls();
        result = result * 59 + ($urls == null ? 43 : ((Object)$urls).hashCode());
        return result;
    }

    public static class WebhookRequestBuilder {
        private String webhookName;
        private ArrayList<String> urls;

        public WebhookRequestBuilder webhookName(WebhookName webhookName) {
            this.webhookName = webhookName.getValue();
            return this;
        }

        WebhookRequestBuilder() {
        }

        public WebhookRequestBuilder url(String url) {
            if (this.urls == null) {
                this.urls = new ArrayList();
            }
            this.urls.add(url);
            return this;
        }

        public WebhookRequestBuilder urls(Collection<? extends String> urls) {
            if (urls == null) {
                throw new NullPointerException("urls cannot be null");
            }
            if (this.urls == null) {
                this.urls = new ArrayList();
            }
            this.urls.addAll(urls);
            return this;
        }

        public WebhookRequestBuilder clearUrls() {
            if (this.urls != null) {
                this.urls.clear();
            }
            return this;
        }

        public WebhookRequest build() {
            Set<String> urls;
            switch (this.urls == null ? 0 : this.urls.size()) {
                case 0: {
                    urls = Collections.emptySet();
                    break;
                }
                case 1: {
                    urls = Collections.singleton(this.urls.get(0));
                    break;
                }
                default: {
                    urls = new LinkedHashSet(this.urls.size() < 0x40000000 ? 1 + this.urls.size() + (this.urls.size() - 3) / 3 : Integer.MAX_VALUE);
                    urls.addAll(this.urls);
                    urls = Collections.unmodifiableSet(urls);
                }
            }
            return new WebhookRequest(this.webhookName, urls);
        }

        public String toString() {
            return "WebhookRequest.WebhookRequestBuilder(webhookName=" + this.webhookName + ", urls=" + this.urls + ")";
        }
    }

    private static class CustomWebhookRequestBuilder
    extends WebhookRequestBuilder {
        private CustomWebhookRequestBuilder() {
        }

        @Override
        public WebhookRequest build() {
            if (CollectionUtils.isEmpty((Collection)((WebhookRequestBuilder)this).urls)) {
                throw new IllegalArgumentException(String.format("Field '%s' cannot be null or empty!", "url(s)"));
            }
            ((WebhookRequestBuilder)this).urls.stream().filter(StringUtils::isNotBlank).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Field '%s' cannot be null or empty!", "url(s)")));
            return super.build();
        }
    }
}

