/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.form;

import com.mailgun.form.CustomProperties;
import feign.form.FormProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.rmi.UnexpectedException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public final class PojoUtil {
    public static boolean isUserPojo(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        Class<?> type = object.getClass();
        String packageName = type.getPackage().getName();
        return !packageName.startsWith("java.");
    }

    public static boolean isUserPojo(@NonNull Type type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        String typeName = type.toString();
        return !typeName.startsWith("class java.");
    }

    public static Map<String, Object> toMap(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Class<?> type = object.getClass();
        SetAccessibleAction setAccessibleAction = new SetAccessibleAction();
        for (Field field : type.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers)) continue;
            setAccessibleAction.setField(field);
            AccessController.doPrivileged(setAccessibleAction);
            Object fieldValue = field.get(object);
            if (fieldValue == null) continue;
            if (field.isAnnotationPresent(CustomProperties.class)) {
                String prefix = field.getAnnotation(CustomProperties.class).prefix();
                Map properties = (Map)fieldValue;
                for (Map.Entry entry : properties.entrySet()) {
                    result.put(prefix + (String)entry.getKey(), entry.getValue());
                }
                continue;
            }
            String propertyKey = field.isAnnotationPresent(FormProperty.class) ? field.getAnnotation(FormProperty.class).value() : field.getName();
            result.put(propertyKey, fieldValue);
        }
        return result;
    }

    private PojoUtil() throws UnexpectedException {
        throw new UnexpectedException("It is not allowed to instantiate this class");
    }

    private static class SetAccessibleAction
    implements PrivilegedAction<Object> {
        private Field field;

        @Override
        public Object run() {
            this.field.setAccessible(true);
            return null;
        }

        public void setField(Field field) {
            this.field = field;
        }
    }
}

