/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.model.events;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mailgun.enums.Severity;
import com.mailgun.model.events.EventClientInfo;
import com.mailgun.model.events.EventDeliveryStatus;
import com.mailgun.model.events.EventEnvelope;
import com.mailgun.model.events.EventFlags;
import com.mailgun.model.events.EventGeolocation;
import com.mailgun.model.events.EventMailingList;
import com.mailgun.model.events.EventMember;
import com.mailgun.model.events.EventMessage;
import com.mailgun.model.events.EventRoute;
import com.mailgun.model.events.RejectedEventInfo;
import com.mailgun.model.events.Storage;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=EventItemBuilder.class)
public final class EventItem {
    private final String id;
    private final String event;
    private final ZonedDateTime timestamp;
    @JsonProperty(value="log-level")
    private final String logLevel;
    private final EventMember member;
    private final String method;
    private final Severity severity;
    private final String reason;
    private final List<EventRoute> routes;
    private final EventEnvelope envelope;
    private final EventFlags flags;
    @JsonProperty(value="delivery-status")
    private final EventDeliveryStatus deliveryStatus;
    private final RejectedEventInfo reject;
    private final EventMessage message;
    private final Storage storage;
    private final String recipient;
    @JsonProperty(value="recipient-domain")
    private final String recipientDomain;
    private final List<String> campaigns;
    private final EventGeolocation geolocation;
    private final List<String> tags;
    @JsonProperty(value="user-variables")
    private final Map<String, String> userVariables;
    private final String url;
    private final String ip;
    @JsonProperty(value="client-info")
    private final EventClientInfo clientInfo;
    @JsonProperty(value="task-id")
    private final String taskId;
    private final String format;
    @JsonProperty(value="mailing-list")
    private final EventMailingList mailingList;
    @JsonProperty(value="failed-count")
    private final Integer failedCount;
    @JsonProperty(value="upserted-count")
    private final Integer upsertedCount;
    @JsonProperty(value="is-upsert")
    private final Boolean isUpsert;

    EventItem(String id, String event, ZonedDateTime timestamp, String logLevel, EventMember member, String method, Severity severity, String reason, List<EventRoute> routes, EventEnvelope envelope, EventFlags flags, EventDeliveryStatus deliveryStatus, RejectedEventInfo reject, EventMessage message, Storage storage, String recipient, String recipientDomain, List<String> campaigns, EventGeolocation geolocation, List<String> tags, Map<String, String> userVariables, String url, String ip, EventClientInfo clientInfo, String taskId, String format, EventMailingList mailingList, Integer failedCount, Integer upsertedCount, Boolean isUpsert) {
        this.id = id;
        this.event = event;
        this.timestamp = timestamp;
        this.logLevel = logLevel;
        this.member = member;
        this.method = method;
        this.severity = severity;
        this.reason = reason;
        this.routes = routes;
        this.envelope = envelope;
        this.flags = flags;
        this.deliveryStatus = deliveryStatus;
        this.reject = reject;
        this.message = message;
        this.storage = storage;
        this.recipient = recipient;
        this.recipientDomain = recipientDomain;
        this.campaigns = campaigns;
        this.geolocation = geolocation;
        this.tags = tags;
        this.userVariables = userVariables;
        this.url = url;
        this.ip = ip;
        this.clientInfo = clientInfo;
        this.taskId = taskId;
        this.format = format;
        this.mailingList = mailingList;
        this.failedCount = failedCount;
        this.upsertedCount = upsertedCount;
        this.isUpsert = isUpsert;
    }

    public static EventItemBuilder builder() {
        return new EventItemBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getEvent() {
        return this.event;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public EventMember getMember() {
        return this.member;
    }

    public String getMethod() {
        return this.method;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getReason() {
        return this.reason;
    }

    public List<EventRoute> getRoutes() {
        return this.routes;
    }

    public EventEnvelope getEnvelope() {
        return this.envelope;
    }

    public EventFlags getFlags() {
        return this.flags;
    }

    public EventDeliveryStatus getDeliveryStatus() {
        return this.deliveryStatus;
    }

    public RejectedEventInfo getReject() {
        return this.reject;
    }

    public EventMessage getMessage() {
        return this.message;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public String getRecipientDomain() {
        return this.recipientDomain;
    }

    public List<String> getCampaigns() {
        return this.campaigns;
    }

    public EventGeolocation getGeolocation() {
        return this.geolocation;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Map<String, String> getUserVariables() {
        return this.userVariables;
    }

    public String getUrl() {
        return this.url;
    }

    public String getIp() {
        return this.ip;
    }

    public EventClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getFormat() {
        return this.format;
    }

    public EventMailingList getMailingList() {
        return this.mailingList;
    }

    public Integer getFailedCount() {
        return this.failedCount;
    }

    public Integer getUpsertedCount() {
        return this.upsertedCount;
    }

    public Boolean getIsUpsert() {
        return this.isUpsert;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventItem)) {
            return false;
        }
        EventItem other = (EventItem)o;
        Integer this$failedCount = this.getFailedCount();
        Integer other$failedCount = other.getFailedCount();
        if (this$failedCount == null ? other$failedCount != null : !((Object)this$failedCount).equals(other$failedCount)) {
            return false;
        }
        Integer this$upsertedCount = this.getUpsertedCount();
        Integer other$upsertedCount = other.getUpsertedCount();
        if (this$upsertedCount == null ? other$upsertedCount != null : !((Object)this$upsertedCount).equals(other$upsertedCount)) {
            return false;
        }
        Boolean this$isUpsert = this.getIsUpsert();
        Boolean other$isUpsert = other.getIsUpsert();
        if (this$isUpsert == null ? other$isUpsert != null : !((Object)this$isUpsert).equals(other$isUpsert)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        ZonedDateTime this$timestamp = this.getTimestamp();
        ZonedDateTime other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$logLevel = this.getLogLevel();
        String other$logLevel = other.getLogLevel();
        if (this$logLevel == null ? other$logLevel != null : !this$logLevel.equals(other$logLevel)) {
            return false;
        }
        EventMember this$member = this.getMember();
        EventMember other$member = other.getMember();
        if (this$member == null ? other$member != null : !((Object)this$member).equals(other$member)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        Severity this$severity = this.getSeverity();
        Severity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        List<EventRoute> this$routes = this.getRoutes();
        List<EventRoute> other$routes = other.getRoutes();
        if (this$routes == null ? other$routes != null : !((Object)this$routes).equals(other$routes)) {
            return false;
        }
        EventEnvelope this$envelope = this.getEnvelope();
        EventEnvelope other$envelope = other.getEnvelope();
        if (this$envelope == null ? other$envelope != null : !((Object)this$envelope).equals(other$envelope)) {
            return false;
        }
        EventFlags this$flags = this.getFlags();
        EventFlags other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        EventDeliveryStatus this$deliveryStatus = this.getDeliveryStatus();
        EventDeliveryStatus other$deliveryStatus = other.getDeliveryStatus();
        if (this$deliveryStatus == null ? other$deliveryStatus != null : !((Object)this$deliveryStatus).equals(other$deliveryStatus)) {
            return false;
        }
        RejectedEventInfo this$reject = this.getReject();
        RejectedEventInfo other$reject = other.getReject();
        if (this$reject == null ? other$reject != null : !((Object)this$reject).equals(other$reject)) {
            return false;
        }
        EventMessage this$message = this.getMessage();
        EventMessage other$message = other.getMessage();
        if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
            return false;
        }
        Storage this$storage = this.getStorage();
        Storage other$storage = other.getStorage();
        if (this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage)) {
            return false;
        }
        String this$recipient = this.getRecipient();
        String other$recipient = other.getRecipient();
        if (this$recipient == null ? other$recipient != null : !this$recipient.equals(other$recipient)) {
            return false;
        }
        String this$recipientDomain = this.getRecipientDomain();
        String other$recipientDomain = other.getRecipientDomain();
        if (this$recipientDomain == null ? other$recipientDomain != null : !this$recipientDomain.equals(other$recipientDomain)) {
            return false;
        }
        List<String> this$campaigns = this.getCampaigns();
        List<String> other$campaigns = other.getCampaigns();
        if (this$campaigns == null ? other$campaigns != null : !((Object)this$campaigns).equals(other$campaigns)) {
            return false;
        }
        EventGeolocation this$geolocation = this.getGeolocation();
        EventGeolocation other$geolocation = other.getGeolocation();
        if (this$geolocation == null ? other$geolocation != null : !((Object)this$geolocation).equals(other$geolocation)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Map<String, String> this$userVariables = this.getUserVariables();
        Map<String, String> other$userVariables = other.getUserVariables();
        if (this$userVariables == null ? other$userVariables != null : !((Object)this$userVariables).equals(other$userVariables)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        EventClientInfo this$clientInfo = this.getClientInfo();
        EventClientInfo other$clientInfo = other.getClientInfo();
        if (this$clientInfo == null ? other$clientInfo != null : !((Object)this$clientInfo).equals(other$clientInfo)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        EventMailingList this$mailingList = this.getMailingList();
        EventMailingList other$mailingList = other.getMailingList();
        return !(this$mailingList == null ? other$mailingList != null : !((Object)this$mailingList).equals(other$mailingList));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $failedCount = this.getFailedCount();
        result = result * 59 + ($failedCount == null ? 43 : ((Object)$failedCount).hashCode());
        Integer $upsertedCount = this.getUpsertedCount();
        result = result * 59 + ($upsertedCount == null ? 43 : ((Object)$upsertedCount).hashCode());
        Boolean $isUpsert = this.getIsUpsert();
        result = result * 59 + ($isUpsert == null ? 43 : ((Object)$isUpsert).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        ZonedDateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : $logLevel.hashCode());
        EventMember $member = this.getMember();
        result = result * 59 + ($member == null ? 43 : ((Object)$member).hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        Severity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        List<EventRoute> $routes = this.getRoutes();
        result = result * 59 + ($routes == null ? 43 : ((Object)$routes).hashCode());
        EventEnvelope $envelope = this.getEnvelope();
        result = result * 59 + ($envelope == null ? 43 : ((Object)$envelope).hashCode());
        EventFlags $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        EventDeliveryStatus $deliveryStatus = this.getDeliveryStatus();
        result = result * 59 + ($deliveryStatus == null ? 43 : ((Object)$deliveryStatus).hashCode());
        RejectedEventInfo $reject = this.getReject();
        result = result * 59 + ($reject == null ? 43 : ((Object)$reject).hashCode());
        EventMessage $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        Storage $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
        String $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : $recipient.hashCode());
        String $recipientDomain = this.getRecipientDomain();
        result = result * 59 + ($recipientDomain == null ? 43 : $recipientDomain.hashCode());
        List<String> $campaigns = this.getCampaigns();
        result = result * 59 + ($campaigns == null ? 43 : ((Object)$campaigns).hashCode());
        EventGeolocation $geolocation = this.getGeolocation();
        result = result * 59 + ($geolocation == null ? 43 : ((Object)$geolocation).hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Map<String, String> $userVariables = this.getUserVariables();
        result = result * 59 + ($userVariables == null ? 43 : ((Object)$userVariables).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        EventClientInfo $clientInfo = this.getClientInfo();
        result = result * 59 + ($clientInfo == null ? 43 : ((Object)$clientInfo).hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        EventMailingList $mailingList = this.getMailingList();
        result = result * 59 + ($mailingList == null ? 43 : ((Object)$mailingList).hashCode());
        return result;
    }

    public String toString() {
        return "EventItem(id=" + this.getId() + ", event=" + this.getEvent() + ", timestamp=" + this.getTimestamp() + ", logLevel=" + this.getLogLevel() + ", member=" + this.getMember() + ", method=" + this.getMethod() + ", severity=" + this.getSeverity() + ", reason=" + this.getReason() + ", routes=" + this.getRoutes() + ", envelope=" + this.getEnvelope() + ", flags=" + this.getFlags() + ", deliveryStatus=" + this.getDeliveryStatus() + ", reject=" + this.getReject() + ", message=" + this.getMessage() + ", storage=" + this.getStorage() + ", recipient=" + this.getRecipient() + ", recipientDomain=" + this.getRecipientDomain() + ", campaigns=" + this.getCampaigns() + ", geolocation=" + this.getGeolocation() + ", tags=" + this.getTags() + ", userVariables=" + this.getUserVariables() + ", url=" + this.getUrl() + ", ip=" + this.getIp() + ", clientInfo=" + this.getClientInfo() + ", taskId=" + this.getTaskId() + ", format=" + this.getFormat() + ", mailingList=" + this.getMailingList() + ", failedCount=" + this.getFailedCount() + ", upsertedCount=" + this.getUpsertedCount() + ", isUpsert=" + this.getIsUpsert() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class EventItemBuilder {
        private String id;
        private String event;
        private ZonedDateTime timestamp;
        private String logLevel;
        private EventMember member;
        private String method;
        private Severity severity;
        private String reason;
        private List<EventRoute> routes;
        private EventEnvelope envelope;
        private EventFlags flags;
        private EventDeliveryStatus deliveryStatus;
        private RejectedEventInfo reject;
        private EventMessage message;
        private Storage storage;
        private String recipient;
        private String recipientDomain;
        private List<String> campaigns;
        private EventGeolocation geolocation;
        private List<String> tags;
        private Map<String, String> userVariables;
        private String url;
        private String ip;
        private EventClientInfo clientInfo;
        private String taskId;
        private String format;
        private EventMailingList mailingList;
        private Integer failedCount;
        private Integer upsertedCount;
        private Boolean isUpsert;

        EventItemBuilder() {
        }

        public EventItemBuilder id(String id) {
            this.id = id;
            return this;
        }

        public EventItemBuilder event(String event) {
            this.event = event;
            return this;
        }

        public EventItemBuilder timestamp(ZonedDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="log-level")
        public EventItemBuilder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public EventItemBuilder member(EventMember member) {
            this.member = member;
            return this;
        }

        public EventItemBuilder method(String method) {
            this.method = method;
            return this;
        }

        public EventItemBuilder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public EventItemBuilder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public EventItemBuilder routes(List<EventRoute> routes) {
            this.routes = routes;
            return this;
        }

        public EventItemBuilder envelope(EventEnvelope envelope) {
            this.envelope = envelope;
            return this;
        }

        public EventItemBuilder flags(EventFlags flags) {
            this.flags = flags;
            return this;
        }

        @JsonProperty(value="delivery-status")
        public EventItemBuilder deliveryStatus(EventDeliveryStatus deliveryStatus) {
            this.deliveryStatus = deliveryStatus;
            return this;
        }

        public EventItemBuilder reject(RejectedEventInfo reject) {
            this.reject = reject;
            return this;
        }

        public EventItemBuilder message(EventMessage message) {
            this.message = message;
            return this;
        }

        public EventItemBuilder storage(Storage storage) {
            this.storage = storage;
            return this;
        }

        public EventItemBuilder recipient(String recipient) {
            this.recipient = recipient;
            return this;
        }

        @JsonProperty(value="recipient-domain")
        public EventItemBuilder recipientDomain(String recipientDomain) {
            this.recipientDomain = recipientDomain;
            return this;
        }

        public EventItemBuilder campaigns(List<String> campaigns) {
            this.campaigns = campaigns;
            return this;
        }

        public EventItemBuilder geolocation(EventGeolocation geolocation) {
            this.geolocation = geolocation;
            return this;
        }

        public EventItemBuilder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        @JsonProperty(value="user-variables")
        public EventItemBuilder userVariables(Map<String, String> userVariables) {
            this.userVariables = userVariables;
            return this;
        }

        public EventItemBuilder url(String url) {
            this.url = url;
            return this;
        }

        public EventItemBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        @JsonProperty(value="client-info")
        public EventItemBuilder clientInfo(EventClientInfo clientInfo) {
            this.clientInfo = clientInfo;
            return this;
        }

        @JsonProperty(value="task-id")
        public EventItemBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public EventItemBuilder format(String format) {
            this.format = format;
            return this;
        }

        @JsonProperty(value="mailing-list")
        public EventItemBuilder mailingList(EventMailingList mailingList) {
            this.mailingList = mailingList;
            return this;
        }

        @JsonProperty(value="failed-count")
        public EventItemBuilder failedCount(Integer failedCount) {
            this.failedCount = failedCount;
            return this;
        }

        @JsonProperty(value="upserted-count")
        public EventItemBuilder upsertedCount(Integer upsertedCount) {
            this.upsertedCount = upsertedCount;
            return this;
        }

        @JsonProperty(value="is-upsert")
        public EventItemBuilder isUpsert(Boolean isUpsert) {
            this.isUpsert = isUpsert;
            return this;
        }

        public EventItem build() {
            return new EventItem(this.id, this.event, this.timestamp, this.logLevel, this.member, this.method, this.severity, this.reason, this.routes, this.envelope, this.flags, this.deliveryStatus, this.reject, this.message, this.storage, this.recipient, this.recipientDomain, this.campaigns, this.geolocation, this.tags, this.userVariables, this.url, this.ip, this.clientInfo, this.taskId, this.format, this.mailingList, this.failedCount, this.upsertedCount, this.isUpsert);
        }

        public String toString() {
            return "EventItem.EventItemBuilder(id=" + this.id + ", event=" + this.event + ", timestamp=" + this.timestamp + ", logLevel=" + this.logLevel + ", member=" + this.member + ", method=" + this.method + ", severity=" + this.severity + ", reason=" + this.reason + ", routes=" + this.routes + ", envelope=" + this.envelope + ", flags=" + this.flags + ", deliveryStatus=" + this.deliveryStatus + ", reject=" + this.reject + ", message=" + this.message + ", storage=" + this.storage + ", recipient=" + this.recipient + ", recipientDomain=" + this.recipientDomain + ", campaigns=" + this.campaigns + ", geolocation=" + this.geolocation + ", tags=" + this.tags + ", userVariables=" + this.userVariables + ", url=" + this.url + ", ip=" + this.ip + ", clientInfo=" + this.clientInfo + ", taskId=" + this.taskId + ", format=" + this.format + ", mailingList=" + this.mailingList + ", failedCount=" + this.failedCount + ", upsertedCount=" + this.upsertedCount + ", isUpsert=" + this.isUpsert + ")";
        }
    }
}

