/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.model.metrics;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mailgun.enums.Resolution;
import com.mailgun.model.Pagination;
import com.mailgun.model.metrics.MetricAggregates;
import com.mailgun.model.metrics.MetricsItem;
import java.time.ZonedDateTime;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=MetricsResponseBuilder.class)
public final class MetricsResponse<T> {
    private final List<MetricsItem<T>> items;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="EEE, dd MMM yyyy HH:mm:ss Z", locale="en")
    private final ZonedDateTime start;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="EEE, dd MMM yyyy HH:mm:ss Z", locale="en")
    private final ZonedDateTime end;
    private final Resolution resolution;
    private final List<String> dimensions;
    private final String duration;
    private final MetricAggregates<T> aggregates;
    private final Pagination pagination;

    MetricsResponse(List<MetricsItem<T>> items, ZonedDateTime start, ZonedDateTime end, Resolution resolution, List<String> dimensions, String duration, MetricAggregates<T> aggregates, Pagination pagination) {
        this.items = items;
        this.start = start;
        this.end = end;
        this.resolution = resolution;
        this.dimensions = dimensions;
        this.duration = duration;
        this.aggregates = aggregates;
        this.pagination = pagination;
    }

    public static <T> MetricsResponseBuilder<T> builder() {
        return new MetricsResponseBuilder();
    }

    public List<MetricsItem<T>> getItems() {
        return this.items;
    }

    public ZonedDateTime getStart() {
        return this.start;
    }

    public ZonedDateTime getEnd() {
        return this.end;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public List<String> getDimensions() {
        return this.dimensions;
    }

    public String getDuration() {
        return this.duration;
    }

    public MetricAggregates<T> getAggregates() {
        return this.aggregates;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricsResponse)) {
            return false;
        }
        MetricsResponse other = (MetricsResponse)o;
        List<MetricsItem<T>> this$items = this.getItems();
        List<MetricsItem<T>> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        ZonedDateTime this$start = this.getStart();
        ZonedDateTime other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        ZonedDateTime this$end = this.getEnd();
        ZonedDateTime other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        Resolution this$resolution = this.getResolution();
        Resolution other$resolution = other.getResolution();
        if (this$resolution == null ? other$resolution != null : !((Object)((Object)this$resolution)).equals((Object)other$resolution)) {
            return false;
        }
        List<String> this$dimensions = this.getDimensions();
        List<String> other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !((Object)this$dimensions).equals(other$dimensions)) {
            return false;
        }
        String this$duration = this.getDuration();
        String other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) {
            return false;
        }
        MetricAggregates<T> this$aggregates = this.getAggregates();
        MetricAggregates<T> other$aggregates = other.getAggregates();
        if (this$aggregates == null ? other$aggregates != null : !((Object)this$aggregates).equals(other$aggregates)) {
            return false;
        }
        Pagination this$pagination = this.getPagination();
        Pagination other$pagination = other.getPagination();
        return !(this$pagination == null ? other$pagination != null : !this$pagination.equals(other$pagination));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<MetricsItem<T>> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        ZonedDateTime $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        ZonedDateTime $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        Resolution $resolution = this.getResolution();
        result = result * 59 + ($resolution == null ? 43 : ((Object)((Object)$resolution)).hashCode());
        List<String> $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : ((Object)$dimensions).hashCode());
        String $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
        MetricAggregates<T> $aggregates = this.getAggregates();
        result = result * 59 + ($aggregates == null ? 43 : ((Object)$aggregates).hashCode());
        Pagination $pagination = this.getPagination();
        result = result * 59 + ($pagination == null ? 43 : $pagination.hashCode());
        return result;
    }

    public String toString() {
        return "MetricsResponse(items=" + this.getItems() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ", resolution=" + this.getResolution() + ", dimensions=" + this.getDimensions() + ", duration=" + this.getDuration() + ", aggregates=" + this.getAggregates() + ", pagination=" + this.getPagination() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class MetricsResponseBuilder<T> {
        private List<MetricsItem<T>> items;
        private ZonedDateTime start;
        private ZonedDateTime end;
        private Resolution resolution;
        private List<String> dimensions;
        private String duration;
        private MetricAggregates<T> aggregates;
        private Pagination pagination;

        MetricsResponseBuilder() {
        }

        public MetricsResponseBuilder<T> items(List<MetricsItem<T>> items) {
            this.items = items;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="EEE, dd MMM yyyy HH:mm:ss Z", locale="en")
        public MetricsResponseBuilder<T> start(ZonedDateTime start) {
            this.start = start;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="EEE, dd MMM yyyy HH:mm:ss Z", locale="en")
        public MetricsResponseBuilder<T> end(ZonedDateTime end) {
            this.end = end;
            return this;
        }

        public MetricsResponseBuilder<T> resolution(Resolution resolution) {
            this.resolution = resolution;
            return this;
        }

        public MetricsResponseBuilder<T> dimensions(List<String> dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public MetricsResponseBuilder<T> duration(String duration) {
            this.duration = duration;
            return this;
        }

        public MetricsResponseBuilder<T> aggregates(MetricAggregates<T> aggregates) {
            this.aggregates = aggregates;
            return this;
        }

        public MetricsResponseBuilder<T> pagination(Pagination pagination) {
            this.pagination = pagination;
            return this;
        }

        public MetricsResponse<T> build() {
            return new MetricsResponse<T>(this.items, this.start, this.end, this.resolution, this.dimensions, this.duration, this.aggregates, this.pagination);
        }

        public String toString() {
            return "MetricsResponse.MetricsResponseBuilder(items=" + this.items + ", start=" + this.start + ", end=" + this.end + ", resolution=" + this.resolution + ", dimensions=" + this.dimensions + ", duration=" + this.duration + ", aggregates=" + this.aggregates + ", pagination=" + this.pagination + ")";
        }
    }
}

