/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.model.tags;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mailgun.enums.ResolutionPeriod;
import com.mailgun.model.stats.Stats;
import java.time.ZonedDateTime;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=TagStatsResultBuilder.class)
public final class TagStatsResult {
    private final String tag;
    private final String description;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="EEE, d MMM yyyy HH:mm:ss z", locale="en")
    private final ZonedDateTime start;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="EEE, d MMM yyyy HH:mm:ss z", locale="en")
    private final ZonedDateTime end;
    private final ResolutionPeriod resolution;
    private final List<Stats> stats;

    TagStatsResult(String tag, String description, ZonedDateTime start, ZonedDateTime end, ResolutionPeriod resolution, List<Stats> stats) {
        this.tag = tag;
        this.description = description;
        this.start = start;
        this.end = end;
        this.resolution = resolution;
        this.stats = stats;
    }

    public static TagStatsResultBuilder builder() {
        return new TagStatsResultBuilder();
    }

    public String getTag() {
        return this.tag;
    }

    public String getDescription() {
        return this.description;
    }

    public ZonedDateTime getStart() {
        return this.start;
    }

    public ZonedDateTime getEnd() {
        return this.end;
    }

    public ResolutionPeriod getResolution() {
        return this.resolution;
    }

    public List<Stats> getStats() {
        return this.stats;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TagStatsResult)) {
            return false;
        }
        TagStatsResult other = (TagStatsResult)o;
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ZonedDateTime this$start = this.getStart();
        ZonedDateTime other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        ZonedDateTime this$end = this.getEnd();
        ZonedDateTime other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        ResolutionPeriod this$resolution = this.getResolution();
        ResolutionPeriod other$resolution = other.getResolution();
        if (this$resolution == null ? other$resolution != null : !((Object)((Object)this$resolution)).equals((Object)other$resolution)) {
            return false;
        }
        List<Stats> this$stats = this.getStats();
        List<Stats> other$stats = other.getStats();
        return !(this$stats == null ? other$stats != null : !((Object)this$stats).equals(other$stats));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ZonedDateTime $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        ZonedDateTime $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        ResolutionPeriod $resolution = this.getResolution();
        result = result * 59 + ($resolution == null ? 43 : ((Object)((Object)$resolution)).hashCode());
        List<Stats> $stats = this.getStats();
        result = result * 59 + ($stats == null ? 43 : ((Object)$stats).hashCode());
        return result;
    }

    public String toString() {
        return "TagStatsResult(tag=" + this.getTag() + ", description=" + this.getDescription() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ", resolution=" + this.getResolution() + ", stats=" + this.getStats() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class TagStatsResultBuilder {
        private String tag;
        private String description;
        private ZonedDateTime start;
        private ZonedDateTime end;
        private ResolutionPeriod resolution;
        private List<Stats> stats;

        TagStatsResultBuilder() {
        }

        public TagStatsResultBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public TagStatsResultBuilder description(String description) {
            this.description = description;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="EEE, d MMM yyyy HH:mm:ss z", locale="en")
        public TagStatsResultBuilder start(ZonedDateTime start) {
            this.start = start;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="EEE, d MMM yyyy HH:mm:ss z", locale="en")
        public TagStatsResultBuilder end(ZonedDateTime end) {
            this.end = end;
            return this;
        }

        public TagStatsResultBuilder resolution(ResolutionPeriod resolution) {
            this.resolution = resolution;
            return this;
        }

        public TagStatsResultBuilder stats(List<Stats> stats) {
            this.stats = stats;
            return this;
        }

        public TagStatsResult build() {
            return new TagStatsResult(this.tag, this.description, this.start, this.end, this.resolution, this.stats);
        }

        public String toString() {
            return "TagStatsResult.TagStatsResultBuilder(tag=" + this.tag + ", description=" + this.description + ", start=" + this.start + ", end=" + this.end + ", resolution=" + this.resolution + ", stats=" + this.stats + ")";
        }
    }
}

