/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.interceptors;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MailgunRequestInterceptor
implements RequestInterceptor {
    private final Map<String, Collection<String>> headers;
    private final Map<String, Collection<String>> properties;

    private MailgunRequestInterceptor(Map<String, Collection<String>> headers, Map<String, Collection<String>> properties) {
        this.headers = headers;
        this.properties = properties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void apply(RequestTemplate requestTemplate) {
        requestTemplate.headers(this.headers);
        if (!this.properties.isEmpty()) {
            this.properties.forEach((name, values) -> values.forEach(value -> requestTemplate.query(name, new String[]{value})));
        }
    }

    public static class Builder {
        private final Map<String, Collection<String>> headers = new HashMap<String, Collection<String>>();
        private final Map<String, Collection<String>> properties = new HashMap<String, Collection<String>>();

        public Builder addHeader(String headerName, String headerValue) {
            this.headers.computeIfAbsent(headerName, key -> new ArrayList()).add(headerValue);
            return this;
        }

        public Builder addProperty(String propertyName, String propertyValue) {
            this.properties.computeIfAbsent(propertyName, key -> new ArrayList()).add(propertyValue);
            return this;
        }

        public MailgunRequestInterceptor build() {
            return new MailgunRequestInterceptor(this.headers, this.properties);
        }
    }
}

