/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.model.metrics;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mailgun.enums.Resolution;
import com.mailgun.model.metrics.MetricsFilter;
import java.time.ZonedDateTime;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=MetricsRequestBuilder.class)
public final class MetricsRequest {
    private final ZonedDateTime start;
    private final ZonedDateTime end;
    private final Resolution resolution;
    private final String duration;
    private final List<String> dimensions;
    private final List<String> metrics;
    private final MetricsFilter filter;
    @JsonProperty(value="include_subaccounts")
    private final Boolean includeSubAccounts;
    @JsonProperty(value="include_aggregates")
    private final Boolean includeAggregates;

    MetricsRequest(ZonedDateTime start, ZonedDateTime end, Resolution resolution, String duration, List<String> dimensions, List<String> metrics, MetricsFilter filter, Boolean includeSubAccounts, Boolean includeAggregates) {
        this.start = start;
        this.end = end;
        this.resolution = resolution;
        this.duration = duration;
        this.dimensions = dimensions;
        this.metrics = metrics;
        this.filter = filter;
        this.includeSubAccounts = includeSubAccounts;
        this.includeAggregates = includeAggregates;
    }

    public static MetricsRequestBuilder builder() {
        return new MetricsRequestBuilder();
    }

    public ZonedDateTime getStart() {
        return this.start;
    }

    public ZonedDateTime getEnd() {
        return this.end;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public String getDuration() {
        return this.duration;
    }

    public List<String> getDimensions() {
        return this.dimensions;
    }

    public List<String> getMetrics() {
        return this.metrics;
    }

    public MetricsFilter getFilter() {
        return this.filter;
    }

    public Boolean getIncludeSubAccounts() {
        return this.includeSubAccounts;
    }

    public Boolean getIncludeAggregates() {
        return this.includeAggregates;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricsRequest)) {
            return false;
        }
        MetricsRequest other = (MetricsRequest)o;
        Boolean this$includeSubAccounts = this.getIncludeSubAccounts();
        Boolean other$includeSubAccounts = other.getIncludeSubAccounts();
        if (this$includeSubAccounts == null ? other$includeSubAccounts != null : !((Object)this$includeSubAccounts).equals(other$includeSubAccounts)) {
            return false;
        }
        Boolean this$includeAggregates = this.getIncludeAggregates();
        Boolean other$includeAggregates = other.getIncludeAggregates();
        if (this$includeAggregates == null ? other$includeAggregates != null : !((Object)this$includeAggregates).equals(other$includeAggregates)) {
            return false;
        }
        ZonedDateTime this$start = this.getStart();
        ZonedDateTime other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        ZonedDateTime this$end = this.getEnd();
        ZonedDateTime other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        Resolution this$resolution = this.getResolution();
        Resolution other$resolution = other.getResolution();
        if (this$resolution == null ? other$resolution != null : !((Object)((Object)this$resolution)).equals((Object)other$resolution)) {
            return false;
        }
        String this$duration = this.getDuration();
        String other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) {
            return false;
        }
        List<String> this$dimensions = this.getDimensions();
        List<String> other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !((Object)this$dimensions).equals(other$dimensions)) {
            return false;
        }
        List<String> this$metrics = this.getMetrics();
        List<String> other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        MetricsFilter this$filter = this.getFilter();
        MetricsFilter other$filter = other.getFilter();
        return !(this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $includeSubAccounts = this.getIncludeSubAccounts();
        result = result * 59 + ($includeSubAccounts == null ? 43 : ((Object)$includeSubAccounts).hashCode());
        Boolean $includeAggregates = this.getIncludeAggregates();
        result = result * 59 + ($includeAggregates == null ? 43 : ((Object)$includeAggregates).hashCode());
        ZonedDateTime $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        ZonedDateTime $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        Resolution $resolution = this.getResolution();
        result = result * 59 + ($resolution == null ? 43 : ((Object)((Object)$resolution)).hashCode());
        String $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
        List<String> $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : ((Object)$dimensions).hashCode());
        List<String> $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        MetricsFilter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        return result;
    }

    public String toString() {
        return "MetricsRequest(start=" + this.getStart() + ", end=" + this.getEnd() + ", resolution=" + this.getResolution() + ", duration=" + this.getDuration() + ", dimensions=" + this.getDimensions() + ", metrics=" + this.getMetrics() + ", filter=" + this.getFilter() + ", includeSubAccounts=" + this.getIncludeSubAccounts() + ", includeAggregates=" + this.getIncludeAggregates() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class MetricsRequestBuilder {
        private ZonedDateTime start;
        private ZonedDateTime end;
        private Resolution resolution;
        private String duration;
        private List<String> dimensions;
        private List<String> metrics;
        private MetricsFilter filter;
        private Boolean includeSubAccounts;
        private Boolean includeAggregates;

        MetricsRequestBuilder() {
        }

        public MetricsRequestBuilder start(ZonedDateTime start) {
            this.start = start;
            return this;
        }

        public MetricsRequestBuilder end(ZonedDateTime end) {
            this.end = end;
            return this;
        }

        public MetricsRequestBuilder resolution(Resolution resolution) {
            this.resolution = resolution;
            return this;
        }

        public MetricsRequestBuilder duration(String duration) {
            this.duration = duration;
            return this;
        }

        public MetricsRequestBuilder dimensions(List<String> dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public MetricsRequestBuilder metrics(List<String> metrics) {
            this.metrics = metrics;
            return this;
        }

        public MetricsRequestBuilder filter(MetricsFilter filter) {
            this.filter = filter;
            return this;
        }

        @JsonProperty(value="include_subaccounts")
        public MetricsRequestBuilder includeSubAccounts(Boolean includeSubAccounts) {
            this.includeSubAccounts = includeSubAccounts;
            return this;
        }

        @JsonProperty(value="include_aggregates")
        public MetricsRequestBuilder includeAggregates(Boolean includeAggregates) {
            this.includeAggregates = includeAggregates;
            return this;
        }

        public MetricsRequest build() {
            return new MetricsRequest(this.start, this.end, this.resolution, this.duration, this.dimensions, this.metrics, this.filter, this.includeSubAccounts, this.includeAggregates);
        }

        public String toString() {
            return "MetricsRequest.MetricsRequestBuilder(start=" + this.start + ", end=" + this.end + ", resolution=" + this.resolution + ", duration=" + this.duration + ", dimensions=" + this.dimensions + ", metrics=" + this.metrics + ", filter=" + this.filter + ", includeSubAccounts=" + this.includeSubAccounts + ", includeAggregates=" + this.includeAggregates + ")";
        }
    }
}

