/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.model.webhooks;

import feign.form.FormProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class WebhookUpdateRequest {
    @FormProperty(value="url")
    Set<String> urls;

    public static WebhookUpdateRequestBuilder builder() {
        return new CustomWebhookUpdateRequestBuilder();
    }

    WebhookUpdateRequest(Set<String> urls) {
        this.urls = urls;
    }

    public Set<String> getUrls() {
        return this.urls;
    }

    public String toString() {
        return "WebhookUpdateRequest(urls=" + this.getUrls() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebhookUpdateRequest)) {
            return false;
        }
        WebhookUpdateRequest other = (WebhookUpdateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$urls = this.getUrls();
        Set<String> other$urls = other.getUrls();
        return !(this$urls == null ? other$urls != null : !((Object)this$urls).equals(other$urls));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebhookUpdateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $urls = this.getUrls();
        result = result * 59 + ($urls == null ? 43 : ((Object)$urls).hashCode());
        return result;
    }

    public static class WebhookUpdateRequestBuilder {
        private ArrayList<String> urls;

        WebhookUpdateRequestBuilder() {
        }

        public WebhookUpdateRequestBuilder url(String url) {
            if (this.urls == null) {
                this.urls = new ArrayList();
            }
            this.urls.add(url);
            return this;
        }

        public WebhookUpdateRequestBuilder urls(Collection<? extends String> urls) {
            if (urls == null) {
                throw new NullPointerException("urls cannot be null");
            }
            if (this.urls == null) {
                this.urls = new ArrayList();
            }
            this.urls.addAll(urls);
            return this;
        }

        public WebhookUpdateRequestBuilder clearUrls() {
            if (this.urls != null) {
                this.urls.clear();
            }
            return this;
        }

        public WebhookUpdateRequest build() {
            Set<String> urls;
            switch (this.urls == null ? 0 : this.urls.size()) {
                case 0: {
                    urls = Collections.emptySet();
                    break;
                }
                case 1: {
                    urls = Collections.singleton(this.urls.get(0));
                    break;
                }
                default: {
                    urls = new LinkedHashSet<String>(this.urls.size() < 0x40000000 ? 1 + this.urls.size() + (this.urls.size() - 3) / 3 : Integer.MAX_VALUE);
                    urls.addAll(this.urls);
                    urls = Collections.unmodifiableSet(urls);
                }
            }
            return new WebhookUpdateRequest(urls);
        }

        public String toString() {
            return "WebhookUpdateRequest.WebhookUpdateRequestBuilder(urls=" + this.urls + ")";
        }
    }

    private static class CustomWebhookUpdateRequestBuilder
    extends WebhookUpdateRequestBuilder {
        private CustomWebhookUpdateRequestBuilder() {
        }

        @Override
        public WebhookUpdateRequest build() {
            if (CollectionUtils.isEmpty(this.urls)) {
                throw new IllegalArgumentException(String.format("Field '%s' cannot be null or empty!", "url(s)"));
            }
            this.urls.stream().filter(StringUtils::isNotBlank).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Field '%s' cannot be null or empty!", "url(s)")));
            return super.build();
        }
    }
}

