/*
 * Decompiled with CFR 0.152.
 */
package com.mailjet.client;

import com.mailjet.client.Base64;
import com.mailjet.client.MailjetRequest;
import com.mailjet.client.MailjetResponse;
import com.mailjet.client.errors.MailjetException;
import com.turbomanage.httpclient.BasicHttpClient;
import com.turbomanage.httpclient.BasicRequestHandler;
import com.turbomanage.httpclient.ConsoleRequestLogger;
import com.turbomanage.httpclient.HttpResponse;
import com.turbomanage.httpclient.ParameterMap;
import com.turbomanage.httpclient.RequestHandler;
import com.turbomanage.httpclient.RequestLogger;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import org.json.JSONObject;

public class MailjetClient {
    public static final int NO_DEBUG = 0;
    public static final int VERBOSE_DEBUG = 1;
    public static final int NOCALL_DEBUG = 2;
    private String _baseUrl = "https://api.mailjet.com/v3";
    private BasicHttpClient _client;
    private BasicRequestHandler _handler;
    private String _apiKey;
    private String _apiSecret;
    private int _debug = 0;

    public MailjetClient(String apiKey, String apiSecret) {
        this._apiKey = apiKey;
        this._apiSecret = apiSecret;
        RequestLogger logger = new RequestLogger(){

            public boolean isLoggingEnabled() {
                return false;
            }

            public void log(String string) {
            }

            public void logRequest(HttpURLConnection hurlc, Object o) throws IOException {
            }

            public void logResponse(HttpResponse hr) {
            }
        };
        this._client = new BasicHttpClient();
        this._client.setRequestLogger(logger);
        String authEncBytes = Base64.encode((this._apiKey + ":" + this._apiSecret).getBytes());
        this._client.addHeader("Accept", "application/json").addHeader("user-agent", "mailjet-apiv3-java/v3.1.1").addHeader("Authorization", "Basic " + authEncBytes);
    }

    public MailjetClient(String apiKey, String apiSecret, RequestHandler handler) {
        this._apiKey = apiKey;
        this._apiSecret = apiSecret;
        this._client = new BasicHttpClient("", handler);
        String authEncBytes = Base64.encode((this._apiKey + ":" + this._apiSecret).getBytes());
        this._client.addHeader("Accept", "application/json").addHeader("user-agent", "mailjet-apiv3-java/v3.1.0").addHeader("Authorization", "Basic " + authEncBytes);
    }

    public void setDebug(int debug) {
        this._debug = debug;
        if (this._debug == 1) {
            this._client.setRequestLogger((RequestLogger)new ConsoleRequestLogger());
        }
    }

    public MailjetResponse get(MailjetRequest request) throws MailjetException {
        try {
            String url = this._baseUrl + request.buildUrl();
            if (this._debug == 2) {
                return new MailjetResponse(new JSONObject().put("url", (Object)(url + request.queryString())));
            }
            ParameterMap p = new ParameterMap();
            p.putAll(request._filters);
            HttpResponse response = this._client.get(url, p);
            String json = response.getBodyAsString() != null && !response.getBodyAsString().equals("") ? response.getBodyAsString() : new JSONObject().put("status", response.getStatus()).toString();
            return new MailjetResponse(response.getStatus(), new JSONObject(json));
        }
        catch (MalformedURLException ex) {
            throw new MailjetException("Internal Exception: Malformed URL");
        }
        catch (UnsupportedEncodingException ex) {
            throw new MailjetException("Internal Exception: Unsupported Encoding");
        }
    }

    public MailjetResponse post(MailjetRequest request) throws MailjetException {
        try {
            String url = request.buildUrl();
            if (this._debug == 2) {
                return new MailjetResponse(new JSONObject().put("url", (Object)(this._baseUrl + url)).put("payload", (Object)request.getBody()));
            }
            HttpResponse response = this._client.post(this._baseUrl + url, request.getContentType(), request.getBody().getBytes("UTF8"));
            String json = response.getBodyAsString() != null ? response.getBodyAsString() : new JSONObject().put("status", response.getStatus()).toString();
            return new MailjetResponse(response.getStatus(), new JSONObject(json));
        }
        catch (MalformedURLException ex) {
            throw new MailjetException("Internal Exception: Malformed Url");
        }
        catch (UnsupportedEncodingException ex) {
            throw new MailjetException("Internal Exception: Unsupported Encoding");
        }
    }

    public MailjetResponse put(MailjetRequest request) throws MailjetException {
        try {
            String url = request.buildUrl();
            if (this._debug == 2) {
                return new MailjetResponse(new JSONObject().put("url", (Object)(this._baseUrl + url)).put("payload", (Object)request.getBody()));
            }
            HttpResponse response = this._client.put(this._baseUrl + url, request.getContentType(), request.getBody().getBytes("UTF8"));
            return new MailjetResponse(response.getStatus(), new JSONObject(response.getBodyAsString()));
        }
        catch (MalformedURLException ex) {
            throw new MailjetException("Internal Exception: Malformed Url");
        }
        catch (UnsupportedEncodingException ex) {
            throw new MailjetException("Internal Exception: Unsupported Encoding");
        }
    }

    public MailjetResponse delete(MailjetRequest request) throws MailjetException {
        try {
            String url = request.buildUrl();
            if (this._debug == 2) {
                return new MailjetResponse(new JSONObject().put("url", (Object)(this._baseUrl + url)));
            }
            ParameterMap p = new ParameterMap();
            p.putAll(request._filters);
            HttpResponse response = this._client.delete(this._baseUrl + url, p);
            String json = response.getBodyAsString() != null && !response.getBodyAsString().trim().equals("") ? response.getBodyAsString() : new JSONObject().put("status", response.getStatus()).toString();
            return new MailjetResponse(response.getStatus(), new JSONObject(json));
        }
        catch (MalformedURLException ex) {
            throw new MailjetException("Internal Exception: Malformed Url");
        }
        catch (UnsupportedEncodingException ex) {
            throw new MailjetException("Internal Exception: Unsupported Encoding");
        }
    }
}

