/*
 * Decompiled with CFR 0.152.
 */
package com.mailjet.client;

import com.mailjet.client.errors.MailjetRateLimitException;
import com.mailjet.client.errors.MailjetServerException;
import com.mailjet.client.errors.MailjetSocketTimeoutException;
import com.turbomanage.httpclient.HttpResponse;
import org.json.JSONObject;

public final class MailjetResponseUtil {
    private static final int TOO_MANY_REQUEST_STATUS = 429;
    private static final int INTERNAL_SERVER_ERROR_STATUS = 500;
    private static final String STATUS_PROPERTY = "status";
    private static final String SOCKET_TIMEOUT_EXCEPTION = "Socket Timeout";
    private static final String TOO_MANY_REQUESTS_EXCEPTION = "Too Many Requests";
    private static final String INTERNAL_SERVER_ERROR_GENERAL_EXCEPTION = "Internal Server Error";

    private MailjetResponseUtil() {
    }

    public static void validateMailjetResponse(HttpResponse response) throws MailjetSocketTimeoutException, MailjetRateLimitException, MailjetServerException {
        if (response == null) {
            throw new MailjetSocketTimeoutException(SOCKET_TIMEOUT_EXCEPTION);
        }
        if (response.getStatus() == 429) {
            throw new MailjetRateLimitException(TOO_MANY_REQUESTS_EXCEPTION);
        }
        if (response.getStatus() >= 500 && !MailjetResponseUtil.isValidJSON(response.getBodyAsString())) {
            throw new MailjetServerException(INTERNAL_SERVER_ERROR_GENERAL_EXCEPTION);
        }
    }

    public static String parseResponseBodyToValidString(HttpResponse response) {
        return response.getBodyAsString() != null && !response.getBodyAsString().trim().equals("") ? response.getBodyAsString() : new JSONObject().put(STATUS_PROPERTY, response.getStatus()).toString();
    }

    public static boolean isValidJSON(String json) {
        return json != null && json.trim().startsWith("{");
    }
}

