/*
 * Decompiled with CFR 0.152.
 */
package com.mailjet.client;

import com.mailjet.client.Base64;
import com.mailjet.client.ClientOptions;
import com.mailjet.client.MailjetRequest;
import com.mailjet.client.MailjetResponse;
import com.mailjet.client.MailjetResponseUtil;
import com.mailjet.client.errors.MailjetException;
import com.mailjet.client.errors.MailjetSocketTimeoutException;
import com.turbomanage.httpclient.BasicHttpClient;
import com.turbomanage.httpclient.BasicRequestHandler;
import com.turbomanage.httpclient.ConsoleRequestLogger;
import com.turbomanage.httpclient.HttpResponse;
import com.turbomanage.httpclient.ParameterMap;
import com.turbomanage.httpclient.RequestHandler;
import com.turbomanage.httpclient.RequestLogger;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import org.json.JSONObject;

public class MailjetClient {
    public static final int NO_DEBUG = 0;
    public static final int VERBOSE_DEBUG = 1;
    public static final int NOCALL_DEBUG = 2;
    private ClientOptions _options;
    private BasicHttpClient _client;
    private BasicRequestHandler _handler;
    private String _apiKey;
    private String _apiSecret;
    private String _token;
    private int _debug = 0;

    public MailjetClient(String apiKey, String apiSecret) {
        this.initLogger(null);
        this.initBasicAuth(apiKey, apiSecret);
        this.initOptions(null);
    }

    public MailjetClient(String apiKey, String apiSecret, RequestHandler handler) {
        this.initLogger(handler);
        this.initBasicAuth(apiKey, apiSecret);
        this.initOptions(null);
    }

    public MailjetClient(String apiKey, String apiSecret, ClientOptions options) {
        this.initLogger(null);
        this.initBasicAuth(apiKey, apiSecret);
        this.initOptions(options);
    }

    public MailjetClient(String apiKey, String apiSecret, RequestHandler handler, ClientOptions options) {
        this.initLogger(handler);
        this.initBasicAuth(apiKey, apiSecret);
        this.initOptions(options);
    }

    public MailjetClient(String token) {
        this.initLogger(null);
        this.initTokenAuth(token);
        this.initOptions(null);
    }

    public MailjetClient(String token, RequestHandler handler) {
        this.initLogger(handler);
        this.initTokenAuth(token);
        this.initOptions(null);
    }

    public MailjetClient(String token, ClientOptions options) {
        this.initLogger(null);
        this.initTokenAuth(token);
        this.initOptions(options);
    }

    public MailjetClient(String token, RequestHandler handler, ClientOptions options) {
        this.initLogger(handler);
        this.initTokenAuth(token);
        this.initOptions(options);
    }

    private void initBasicAuth(String apiKey, String apiSecret) {
        this._apiKey = apiKey;
        this._apiSecret = apiSecret;
        String authEncBytes = Base64.encode((this._apiKey + ":" + this._apiSecret).getBytes());
        this._client.addHeader("Accept", "application/json").addHeader("user-agent", "mailjet-apiv3-java/v4.2.1").addHeader("Authorization", "Basic " + authEncBytes);
    }

    private void initTokenAuth(String token) {
        this._token = token;
        this._client.addHeader("Accept", "application/json").addHeader("user-agent", "mailjet-apiv3-java/v4.2.1").addHeader("Authorization", "Bearer " + token);
    }

    private void initLogger(RequestHandler handler) {
        if (handler == null) {
            RequestLogger logger = new RequestLogger(){

                public boolean isLoggingEnabled() {
                    return false;
                }

                public void log(String string) {
                }

                public void logRequest(HttpURLConnection hurlc, Object o) throws IOException {
                }

                public void logResponse(HttpResponse hr) {
                }
            };
            this._client = new BasicHttpClient();
            this._client.setRequestLogger(logger);
        } else {
            this._client = new BasicHttpClient("", handler);
        }
    }

    private void initOptions(ClientOptions options) {
        if (options != null) {
            this.setOptions(options);
        } else {
            this.setOptions(new ClientOptions());
        }
    }

    public void setDebug(int debug) {
        this._debug = debug;
        if (this._debug == 1) {
            this._client.setRequestLogger((RequestLogger)new ConsoleRequestLogger());
        }
    }

    public MailjetResponse get(MailjetRequest request) throws MailjetException, MailjetSocketTimeoutException {
        try {
            String url = this.createUrl() + request.buildUrl();
            if (this._debug == 2) {
                return new MailjetResponse(new JSONObject().put("url", (Object)(url + request.queryString())));
            }
            ParameterMap p = new ParameterMap();
            p.putAll(request._filters);
            HttpResponse response = this._client.get(url, p);
            MailjetResponseUtil.validateMailjetResponse(response);
            String json = response.getBodyAsString() != null && !response.getBodyAsString().equals("") ? response.getBodyAsString() : new JSONObject().put("status", response.getStatus()).toString();
            return new MailjetResponse(response.getStatus(), new JSONObject(json));
        }
        catch (MalformedURLException ex) {
            throw new MailjetException("Internal Exception: Malformed URL");
        }
        catch (UnsupportedEncodingException ex) {
            throw new MailjetException("Internal Exception: Unsupported Encoding");
        }
        catch (NullPointerException e) {
            throw new MailjetException("Connection Exception");
        }
    }

    public MailjetResponse post(MailjetRequest request) throws MailjetException, MailjetSocketTimeoutException {
        try {
            String url = this.createUrl() + request.buildUrl();
            if (this._debug == 2) {
                return new MailjetResponse(new JSONObject().put("url", (Object)url).put("payload", (Object)request.getBody()));
            }
            HttpResponse response = this._client.post(url, request.getContentType(), request.getBody().getBytes("UTF8"));
            MailjetResponseUtil.validateMailjetResponse(response);
            String json = response.getBodyAsString() != null && !response.getBodyAsString().equals("") ? response.getBodyAsString() : new JSONObject().put("status", response.getStatus()).toString();
            return new MailjetResponse(response.getStatus(), new JSONObject(json));
        }
        catch (MalformedURLException ex) {
            throw new MailjetException("Internal Exception: Malformed Url");
        }
        catch (UnsupportedEncodingException ex) {
            throw new MailjetException("Internal Exception: Unsupported Encoding");
        }
        catch (NullPointerException e) {
            throw new MailjetException("Connection Exception");
        }
    }

    public MailjetResponse put(MailjetRequest request) throws MailjetException, MailjetSocketTimeoutException {
        try {
            String url = this.createUrl() + request.buildUrl();
            if (this._debug == 2) {
                return new MailjetResponse(new JSONObject().put("url", (Object)url).put("payload", (Object)request.getBody()));
            }
            HttpResponse response = this._client.put(url, request.getContentType(), request.getBody().getBytes("UTF8"));
            MailjetResponseUtil.validateMailjetResponse(response);
            String json = response.getBodyAsString() != null && !response.getBodyAsString().trim().equals("") ? response.getBodyAsString() : new JSONObject().put("status", response.getStatus()).toString();
            return new MailjetResponse(response.getStatus(), new JSONObject(json));
        }
        catch (MalformedURLException ex) {
            throw new MailjetException("Internal Exception: Malformed Url");
        }
        catch (UnsupportedEncodingException ex) {
            throw new MailjetException("Internal Exception: Unsupported Encoding");
        }
        catch (NullPointerException e) {
            throw new MailjetException("Connection Exception");
        }
    }

    public MailjetResponse delete(MailjetRequest request) throws MailjetException, MailjetSocketTimeoutException {
        try {
            String url = this.createUrl() + request.buildUrl();
            if (this._debug == 2) {
                return new MailjetResponse(new JSONObject().put("url", (Object)url));
            }
            ParameterMap p = new ParameterMap();
            p.putAll(request._filters);
            HttpResponse response = this._client.delete(url, p);
            MailjetResponseUtil.validateMailjetResponse(response);
            String json = response.getBodyAsString() != null && !response.getBodyAsString().trim().equals("") ? response.getBodyAsString() : new JSONObject().put("status", response.getStatus()).toString();
            return new MailjetResponse(response.getStatus(), new JSONObject(json));
        }
        catch (MalformedURLException ex) {
            throw new MailjetException("Internal Exception: Malformed Url");
        }
        catch (UnsupportedEncodingException ex) {
            throw new MailjetException("Internal Exception: Unsupported Encoding");
        }
        catch (NullPointerException e) {
            throw new MailjetException("Connection Exception");
        }
    }

    private void setOptions(ClientOptions options) {
        this._options = options;
    }

    private String createUrl() {
        return this._options.getBaseUrl() + '/' + this._options.getVersion();
    }
}

