/*
 * Decompiled with CFR 0.152.
 */
package com.mailjet.client.easy;

import com.mailjet.client.ClientOptions;
import com.mailjet.client.MailjetClient;
import com.mailjet.client.MailjetRequest;
import com.mailjet.client.easy.MJEasyEmail;
import com.mailjet.client.easy.MJEasySms;
import com.mailjet.client.resource.Email;
import com.mailjet.client.resource.sms.SmsSend;

public class MJEasyClient {
    private final MailjetClient client;
    public static final int NO_DEBUG = 0;
    public static final int VERBOSE_DEBUG = 1;
    public static final int NOCALL_DEBUG = 2;

    public MJEasyClient(String apiKeyPublic, String apiKeyPrivate) {
        this.client = new MailjetClient(apiKeyPublic, apiKeyPrivate);
    }

    public MJEasyClient(String token) {
        this.client = new MailjetClient(token, new ClientOptions("v4"));
    }

    public MJEasyClient() {
        this.client = new MailjetClient(System.getenv("MJ_APIKEY_PUBLIC"), System.getenv("MJ_APIKEY_PRIVATE"));
    }

    public MailjetClient getClient() {
        return this.client;
    }

    public MJEasyClient setDebug(int debug) {
        this.client.setDebug(debug);
        return this;
    }

    public MJEasyEmail email() {
        return new MJEasyEmail(this, new MailjetRequest(Email.resource));
    }

    public MJEasySms sms() {
        return new MJEasySms(this, new MailjetRequest(SmsSend.resource));
    }
}

