/*
 * Decompiled with CFR 0.152.
 */
package com.mailjet.client;

import com.mailjet.client.Base64;
import com.mailjet.client.ClientOptions;
import com.mailjet.client.MailjetRequest;
import com.mailjet.client.MailjetResponse;
import com.mailjet.client.MailjetResponseUtil;
import com.mailjet.client.errors.MailjetClientCommunicationException;
import com.mailjet.client.errors.MailjetException;
import com.mailjet.client.errors.MailjetUnauthorizedException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public class MailjetClient {
    private ClientOptions _options;
    private OkHttpClient _client;
    private static final String userAgent = "mailjet-apiv3-java/v5.1.1";

    @Deprecated
    public MailjetClient(String apiKey, String apiSecret) {
        this(ClientOptions.builder().apiKey(apiKey).apiSecretKey(apiSecret).build());
    }

    @Deprecated
    public MailjetClient(String token) {
        this(ClientOptions.builder().bearerAccessToken(token).build());
    }

    public MailjetClient(ClientOptions clientOptions) {
        this._options = clientOptions;
        this._client = clientOptions.getOkHttpClient() == null ? MailjetClient.createDefaultOkHttpClient() : clientOptions.getOkHttpClient();
    }

    public MailjetResponse get(MailjetRequest request) throws MailjetException {
        MailjetResponse mailjetResponse;
        block8: {
            Request okHttpRequest = this.getPreconfiguredRequestBuilder(request).get().build();
            Response okHttpResponse = this._client.newCall(okHttpRequest).execute();
            try {
                mailjetResponse = this.parseResponse(request, okHttpResponse);
                if (okHttpResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (okHttpResponse != null) {
                        try {
                            okHttpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new MailjetClientCommunicationException("Connection Exception", ex);
                }
            }
            okHttpResponse.close();
        }
        return mailjetResponse;
    }

    public MailjetResponse post(MailjetRequest request) throws MailjetException {
        MailjetResponse mailjetResponse;
        block8: {
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)request.getContentType()), (byte[])request.getBody().getBytes("UTF8"));
            Request okHttpRequest = this.getPreconfiguredRequestBuilder(request).post(requestBody).build();
            Response okHttpResponse = this._client.newCall(okHttpRequest).execute();
            try {
                mailjetResponse = this.parseResponse(request, okHttpResponse);
                if (okHttpResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (okHttpResponse != null) {
                        try {
                            okHttpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new MailjetClientCommunicationException("Connection Exception", ex);
                }
            }
            okHttpResponse.close();
        }
        return mailjetResponse;
    }

    public MailjetResponse put(MailjetRequest request) throws MailjetException {
        MailjetResponse mailjetResponse;
        block8: {
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)request.getContentType()), (byte[])request.getBody().getBytes("UTF8"));
            Request okHttpRequest = this.getPreconfiguredRequestBuilder(request).put(requestBody).build();
            Response okHttpResponse = this._client.newCall(okHttpRequest).execute();
            try {
                mailjetResponse = this.parseResponse(request, okHttpResponse);
                if (okHttpResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (okHttpResponse != null) {
                        try {
                            okHttpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new MailjetClientCommunicationException("Connection Exception", ex);
                }
            }
            okHttpResponse.close();
        }
        return mailjetResponse;
    }

    public MailjetResponse delete(MailjetRequest request) throws MailjetException {
        MailjetResponse mailjetResponse;
        block8: {
            Request okHttpRequest = this.getPreconfiguredRequestBuilder(request).delete().build();
            Response okHttpResponse = this._client.newCall(okHttpRequest).execute();
            try {
                mailjetResponse = this.parseResponse(request, okHttpResponse);
                if (okHttpResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (okHttpResponse != null) {
                        try {
                            okHttpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new MailjetClientCommunicationException("Connection Exception", ex);
                }
            }
            okHttpResponse.close();
        }
        return mailjetResponse;
    }

    private MailjetResponse parseResponse(MailjetRequest request, Response okHttpResponse) throws IOException, MailjetException {
        int responseStatusCode = okHttpResponse.code();
        String responseBody = okHttpResponse.body().string();
        MailjetResponseUtil.validateMailjetResponse(request, responseStatusCode, responseBody);
        String json = MailjetResponseUtil.isValidJSON(responseBody) ? responseBody : new JSONObject().put("status", responseStatusCode).toString();
        return new MailjetResponse(responseStatusCode, json);
    }

    private static OkHttpClient createDefaultOkHttpClient() {
        return new OkHttpClient.Builder().build();
    }

    private Request.Builder getPreconfiguredRequestBuilder(MailjetRequest request) throws MailjetUnauthorizedException, UnsupportedEncodingException {
        String url = request.buildUrl(this._options.getBaseUrl());
        Request.Builder builder = new Request.Builder().addHeader("Accept", "application/json").addHeader("User-Agent", userAgent).url(url);
        switch (request.getAuthenticationType()) {
            case Basic: {
                if (this._options.getApiKey() == null || this._options.getApiSecretKey() == null) {
                    throw new MailjetUnauthorizedException("To do a request to MailJet api, api key and api secret should be set");
                }
                String authEncBytes = Base64.encode((this._options.getApiKey() + ":" + this._options.getApiSecretKey()).getBytes());
                builder.addHeader("Authorization", "Basic " + authEncBytes);
                break;
            }
            case Bearer: {
                if (this._options.getBearerAccessToken() == null) {
                    throw new MailjetUnauthorizedException("To do a request to MailJet api, api access token should be set");
                }
                builder.addHeader("Authorization", "Bearer " + this._options.getBearerAccessToken());
            }
        }
        return builder;
    }
}

