/*
 * Decompiled with CFR 0.152.
 */
package com.mailjet.client.transactional;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mailjet.client.MailjetClient;
import com.mailjet.client.MailjetRequest;
import com.mailjet.client.MailjetResponse;
import com.mailjet.client.errors.MailjetClientRequestException;
import com.mailjet.client.errors.MailjetException;
import com.mailjet.client.resource.Emailv31;
import com.mailjet.client.transactional.TransactionalEmail;
import com.mailjet.client.transactional.response.SendEmailsResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SendEmailsRequest {
    private static final Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).create();
    private List<TransactionalEmail> messages;
    private Boolean sandboxMode;
    private Boolean advanceErrorHandling;

    public SendEmailsResponse sendWith(MailjetClient mailjetClient) throws MailjetException {
        MailjetRequest request = new MailjetRequest(Emailv31.resource);
        request.setBody(gson.toJson((Object)this));
        MailjetResponse response = mailjetClient.post(request);
        String responseContent = response.getRawResponseContent();
        SendEmailsResponse typedResponse = (SendEmailsResponse)gson.fromJson(responseContent, SendEmailsResponse.class);
        if (typedResponse.getMessages() == null && response.getStatus() != 201) {
            throw new MailjetClientRequestException(responseContent, response.getStatus());
        }
        return typedResponse;
    }

    SendEmailsRequest(List<TransactionalEmail> messages, Boolean sandboxMode, Boolean advanceErrorHandling) {
        this.messages = messages;
        this.sandboxMode = sandboxMode;
        this.advanceErrorHandling = advanceErrorHandling;
    }

    public static SendEmailsRequestBuilder builder() {
        return new SendEmailsRequestBuilder();
    }

    public static class SendEmailsRequestBuilder {
        private ArrayList<TransactionalEmail> messages;
        private Boolean sandboxMode;
        private Boolean advanceErrorHandling;

        SendEmailsRequestBuilder() {
        }

        public SendEmailsRequestBuilder message(TransactionalEmail message) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.add(message);
            return this;
        }

        public SendEmailsRequestBuilder messages(Collection<? extends TransactionalEmail> messages) {
            if (messages == null) {
                throw new NullPointerException("messages cannot be null");
            }
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.addAll(messages);
            return this;
        }

        public SendEmailsRequestBuilder clearMessages() {
            if (this.messages != null) {
                this.messages.clear();
            }
            return this;
        }

        public SendEmailsRequestBuilder sandboxMode(Boolean sandboxMode) {
            this.sandboxMode = sandboxMode;
            return this;
        }

        public SendEmailsRequestBuilder advanceErrorHandling(Boolean advanceErrorHandling) {
            this.advanceErrorHandling = advanceErrorHandling;
            return this;
        }

        public SendEmailsRequest build() {
            List<TransactionalEmail> messages;
            switch (this.messages == null ? 0 : this.messages.size()) {
                case 0: {
                    messages = Collections.emptyList();
                    break;
                }
                case 1: {
                    messages = Collections.singletonList(this.messages.get(0));
                    break;
                }
                default: {
                    messages = Collections.unmodifiableList(new ArrayList<TransactionalEmail>(this.messages));
                }
            }
            return new SendEmailsRequest(messages, this.sandboxMode, this.advanceErrorHandling);
        }

        public String toString() {
            return "SendEmailsRequest.SendEmailsRequestBuilder(messages=" + this.messages + ", sandboxMode=" + this.sandboxMode + ", advanceErrorHandling=" + this.advanceErrorHandling + ")";
        }
    }
}

