/*
 * Decompiled with CFR 0.152.
 */
package com.mailjet.client.transactional;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;

public class Attachment {
    private String filename;
    private String contentType;
    private String base64Content;
    private String contentID;

    public static Attachment fromFile(String pathToFile) throws IOException {
        File file = new File(pathToFile);
        Path path = file.toPath();
        String mimeType = Files.probeContentType(path);
        byte[] fileContent = Files.readAllBytes(path);
        String base64Content = Base64.getEncoder().encodeToString(fileContent);
        return new AttachmentBuilder().base64Content(base64Content).contentType(mimeType).filename(path.getFileName().toString()).build();
    }

    public static Attachment fromInputStream(InputStream inputStream, String attachmentFileName, String contentType) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4000];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        String base64Content = Base64.getEncoder().encodeToString(buffer.toByteArray());
        return new AttachmentBuilder().base64Content(base64Content).contentType(contentType).filename(attachmentFileName).build();
    }

    Attachment(String filename, String contentType, String base64Content, String contentID) {
        this.filename = filename;
        this.contentType = contentType;
        this.base64Content = base64Content;
        this.contentID = contentID;
    }

    public static AttachmentBuilder builder() {
        return new AttachmentBuilder();
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getBase64Content() {
        return this.base64Content;
    }

    public String getContentID() {
        return this.contentID;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setBase64Content(String base64Content) {
        this.base64Content = base64Content;
    }

    public void setContentID(String contentID) {
        this.contentID = contentID;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        String this$base64Content = this.getBase64Content();
        String other$base64Content = other.getBase64Content();
        if (this$base64Content == null ? other$base64Content != null : !this$base64Content.equals(other$base64Content)) {
            return false;
        }
        String this$contentID = this.getContentID();
        String other$contentID = other.getContentID();
        return !(this$contentID == null ? other$contentID != null : !this$contentID.equals(other$contentID));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Attachment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        String $base64Content = this.getBase64Content();
        result = result * 59 + ($base64Content == null ? 43 : $base64Content.hashCode());
        String $contentID = this.getContentID();
        result = result * 59 + ($contentID == null ? 43 : $contentID.hashCode());
        return result;
    }

    public String toString() {
        return "Attachment(filename=" + this.getFilename() + ", contentType=" + this.getContentType() + ", base64Content=" + this.getBase64Content() + ", contentID=" + this.getContentID() + ")";
    }

    public static class AttachmentBuilder {
        private String filename;
        private String contentType;
        private String base64Content;
        private String contentID;

        AttachmentBuilder() {
        }

        public AttachmentBuilder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public AttachmentBuilder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public AttachmentBuilder base64Content(String base64Content) {
            this.base64Content = base64Content;
            return this;
        }

        public AttachmentBuilder contentID(String contentID) {
            this.contentID = contentID;
            return this;
        }

        public Attachment build() {
            return new Attachment(this.filename, this.contentType, this.base64Content, this.contentID);
        }

        public String toString() {
            return "Attachment.AttachmentBuilder(filename=" + this.filename + ", contentType=" + this.contentType + ", base64Content=" + this.base64Content + ", contentID=" + this.contentID + ")";
        }
    }
}

