/*
 * Decompiled with CFR 0.152.
 */
package com.mailjet.client;

import com.mailjet.client.errors.MailjetException;
import lombok.Generated;
import org.json.JSONArray;
import org.json.JSONObject;

public class MailjetResponse {
    private final JSONObject responseObject;
    private final String rawResponse;
    private final int status;

    public MailjetResponse(int status, String rawResponse) {
        this.responseObject = new JSONObject(rawResponse);
        this.rawResponse = rawResponse;
        this.status = status;
    }

    public String getRawResponseContent() {
        return this.rawResponse;
    }

    public JSONArray getData() {
        if (this.responseObject.has("Data")) {
            return this.responseObject.getJSONArray("Data");
        }
        if (this.responseObject.has("Sent")) {
            return this.responseObject.getJSONArray("Sent");
        }
        if (this.responseObject.has("Messages")) {
            return this.responseObject.getJSONArray("Messages");
        }
        return new JSONArray().put((Object)this.responseObject);
    }

    public int getTotal() {
        if (this.responseObject.has("Total")) {
            return this.responseObject.getInt("Total");
        }
        return 0;
    }

    public String getString(String key) throws MailjetException {
        try {
            return this.responseObject.getString(key);
        }
        catch (NullPointerException e) {
            throw new MailjetException("No entry found for key: " + key);
        }
    }

    public int getInt(String key) throws MailjetException {
        try {
            return this.responseObject.getInt(key);
        }
        catch (NullPointerException e) {
            throw new MailjetException("No entry found for key: " + key);
        }
    }

    public JSONArray getJSONArray(String key) throws MailjetException {
        try {
            return this.responseObject.getJSONArray(key);
        }
        catch (NullPointerException e) {
            throw new MailjetException("No entry found for key: " + key);
        }
    }

    public int getCount() {
        if (this.responseObject.has("Count")) {
            return this.responseObject.getInt("Count");
        }
        return 0;
    }

    @Generated
    public int getStatus() {
        return this.status;
    }
}

