/*
 * Decompiled with CFR 0.152.
 */
package com.mailjet.client.easy;

import com.mailjet.client.ClientOptions;
import com.mailjet.client.MailjetClient;
import com.mailjet.client.MailjetRequest;
import com.mailjet.client.easy.MJEasyEmail;
import com.mailjet.client.easy.MJEasySms;
import com.mailjet.client.resource.Email;
import com.mailjet.client.resource.sms.SmsSend;
import lombok.Generated;

public class MJEasyClient {
    private final MailjetClient client;

    public MJEasyClient(String apiKeyPublic, String apiKeyPrivate) {
        ClientOptions clientOptions = ClientOptions.builder().apiKey(apiKeyPublic).apiSecretKey(apiKeyPrivate).build();
        this.client = new MailjetClient(clientOptions);
    }

    public MJEasyClient(String token) {
        ClientOptions clientOptions = ClientOptions.builder().bearerAccessToken(token).build();
        this.client = new MailjetClient(clientOptions);
    }

    public MJEasyClient() {
        ClientOptions clientOptions = ClientOptions.builder().apiKey(System.getenv("MJ_APIKEY_PUBLIC")).apiSecretKey(System.getenv("MJ_APIKEY_PRIVATE")).build();
        this.client = new MailjetClient(clientOptions);
    }

    protected MJEasyClient(MailjetClient client) {
        this.client = client;
    }

    public MJEasyEmail email() {
        return new MJEasyEmail(this, new MailjetRequest(Email.resource));
    }

    public MJEasySms sms() {
        return new MJEasySms(this, new MailjetRequest(SmsSend.resource));
    }

    @Generated
    public MailjetClient getClient() {
        return this.client;
    }
}

